<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

// Page (category, tag, archive, author) title

if ( foodie_need_page_title() ) {
	foodie_sc_layouts_showed( 'title', true );
	foodie_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								foodie_show_post_meta(
									apply_filters(
										'foodie_filter_post_meta_args', array(
											'components' => join( ',', foodie_array_get_keys_by_value( foodie_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', foodie_array_get_keys_by_value( foodie_get_theme_option( 'counters' ) ) ),
											'seo'        => foodie_is_on( foodie_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$foodie_blog_title           = foodie_get_blog_title();
							$foodie_blog_title_text      = '';
							$foodie_blog_title_class     = '';
							$foodie_blog_title_link      = '';
							$foodie_blog_title_link_text = '';
							if ( is_array( $foodie_blog_title ) ) {
								$foodie_blog_title_text      = $foodie_blog_title['text'];
								$foodie_blog_title_class     = ! empty( $foodie_blog_title['class'] ) ? ' ' . $foodie_blog_title['class'] : '';
								$foodie_blog_title_link      = ! empty( $foodie_blog_title['link'] ) ? $foodie_blog_title['link'] : '';
								$foodie_blog_title_link_text = ! empty( $foodie_blog_title['link_text'] ) ? $foodie_blog_title['link_text'] : '';
							} else {
								$foodie_blog_title_text = $foodie_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $foodie_blog_title_class ); ?>">
								<?php
								$foodie_top_icon = foodie_get_term_image_small();
								if ( ! empty( $foodie_top_icon ) ) {
									$foodie_attr = foodie_getimagesize( $foodie_top_icon );
									?>
									<img src="<?php echo esc_url( $foodie_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'foodie' ); ?>"
										<?php
										if ( ! empty( $foodie_attr[3] ) ) {
											foodie_show_layout( $foodie_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $foodie_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $foodie_blog_title_link ) && ! empty( $foodie_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $foodie_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $foodie_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'foodie_action_breadcrumbs' );
						$foodie_breadcrumbs = ob_get_contents();
						ob_end_clean();
						foodie_show_layout( $foodie_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
