<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

$foodie_args = get_query_var( 'foodie_logo_args' );

// Site logo
$foodie_logo_type   = isset( $foodie_args['type'] ) ? $foodie_args['type'] : '';
$foodie_logo_image  = foodie_get_logo_image( $foodie_logo_type );
$foodie_logo_text   = foodie_is_on( foodie_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$foodie_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $foodie_logo_image['logo'] ) || ! empty( $foodie_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $foodie_logo_image['logo'] ) ) {
			if ( empty( $foodie_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($foodie_logo_image['logo']) && (int) $foodie_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$foodie_attr = foodie_getimagesize( $foodie_logo_image['logo'] );
				echo '<img src="' . esc_url( $foodie_logo_image['logo'] ) . '"'
						. ( ! empty( $foodie_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $foodie_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $foodie_logo_text ) . '"'
						. ( ! empty( $foodie_attr[3] ) ? ' ' . wp_kses_data( $foodie_attr[3] ) : '' )
						. '>';
			}
		} else {
			foodie_show_layout( foodie_prepare_macros( $foodie_logo_text ), '<span class="logo_text">', '</span>' );
			foodie_show_layout( foodie_prepare_macros( $foodie_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
