<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

$foodie_template_args = get_query_var( 'foodie_template_args' );
$foodie_columns = 1;
if ( is_array( $foodie_template_args ) ) {
	$foodie_columns    = empty( $foodie_template_args['columns'] ) ? 1 : max( 1, $foodie_template_args['columns'] );
	$foodie_blog_style = array( $foodie_template_args['type'], $foodie_columns );
	if ( ! empty( $foodie_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $foodie_columns > 1 ) {
	    $foodie_columns_class = foodie_get_column_class( 1, $foodie_columns, ! empty( $foodie_template_args['columns_tablet']) ? $foodie_template_args['columns_tablet'] : '', ! empty($foodie_template_args['columns_mobile']) ? $foodie_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $foodie_columns_class ); ?>">
		<?php
	}
}
$foodie_expanded    = ! foodie_sidebar_present() && foodie_get_theme_option( 'expand_content' ) == 'expand';
$foodie_post_format = get_post_format();
$foodie_post_format = empty( $foodie_post_format ) ? 'standard' : str_replace( 'post-format-', '', $foodie_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $foodie_post_format ) );
	foodie_add_blog_animation( $foodie_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$foodie_hover      = ! empty( $foodie_template_args['hover'] ) && ! foodie_is_inherit( $foodie_template_args['hover'] )
							? $foodie_template_args['hover']
							: foodie_get_theme_option( 'image_hover' );
	$foodie_components = ! empty( $foodie_template_args['meta_parts'] )
							? ( is_array( $foodie_template_args['meta_parts'] )
								? $foodie_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $foodie_template_args['meta_parts'] ) )
								)
							: foodie_array_get_keys_by_value( foodie_get_theme_option( 'meta_parts' ) );
	foodie_show_post_featured( apply_filters( 'foodie_filter_args_featured',
		array(
			'no_links'   => ! empty( $foodie_template_args['no_links'] ),
			'hover'      => $foodie_hover,
			'meta_parts' => $foodie_components,
			'thumb_size' => ! empty( $foodie_template_args['thumb_size'] )
							? $foodie_template_args['thumb_size']
							: foodie_get_thumb_size( strpos( foodie_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $foodie_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$foodie_template_args
	) );

	// Title and post meta
	$foodie_show_title = get_the_title() != '';
	$foodie_show_meta  = count( $foodie_components ) > 0 && ! in_array( $foodie_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $foodie_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'foodie_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'foodie_action_before_post_title' );
				if ( empty( $foodie_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'foodie_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'foodie_filter_show_blog_excerpt', empty( $foodie_template_args['hide_excerpt'] ) && foodie_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'foodie_filter_show_blog_meta', $foodie_show_meta, $foodie_components, 'excerpt' ) ) {
				if ( count( $foodie_components ) > 0 ) {
					do_action( 'foodie_action_before_post_meta' );
					foodie_show_post_meta(
						apply_filters(
							'foodie_filter_post_meta_args', array(
								'components' => join( ',', $foodie_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'foodie_action_after_post_meta' );
				}
			}

			if ( foodie_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'foodie_action_before_full_post_content' );
					the_content( '' );
					do_action( 'foodie_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'foodie' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'foodie' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				foodie_show_post_content( $foodie_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'foodie_filter_show_blog_readmore',  ! isset( $foodie_template_args['more_button'] ) || ! empty( $foodie_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $foodie_template_args['no_links'] ) ) {
					do_action( 'foodie_action_before_post_readmore' );
					if ( foodie_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						foodie_show_post_more_link( $foodie_template_args, '<p>', '</p>' );
					} else {
						foodie_show_post_comments_link( $foodie_template_args, '<p>', '</p>' );
					}
					do_action( 'foodie_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $foodie_template_args ) ) {
	if ( ! empty( $foodie_template_args['slider'] ) || $foodie_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
