<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

$foodie_template_args = get_query_var( 'foodie_template_args' );

if ( is_array( $foodie_template_args ) ) {
	$foodie_columns    = empty( $foodie_template_args['columns'] ) ? 2 : max( 1, $foodie_template_args['columns'] );
	$foodie_blog_style = array( $foodie_template_args['type'], $foodie_columns );
    $foodie_columns_class = foodie_get_column_class( 1, $foodie_columns, ! empty( $foodie_template_args['columns_tablet']) ? $foodie_template_args['columns_tablet'] : '', ! empty($foodie_template_args['columns_mobile']) ? $foodie_template_args['columns_mobile'] : '' );
} else {
	$foodie_blog_style = explode( '_', foodie_get_theme_option( 'blog_style' ) );
	$foodie_columns    = empty( $foodie_blog_style[1] ) ? 2 : max( 1, $foodie_blog_style[1] );
    $foodie_columns_class = foodie_get_column_class( 1, $foodie_columns );
}
$foodie_expanded   = ! foodie_sidebar_present() && foodie_get_theme_option( 'expand_content' ) == 'expand';

$foodie_post_format = get_post_format();
$foodie_post_format = empty( $foodie_post_format ) ? 'standard' : str_replace( 'post-format-', '', $foodie_post_format );

?><div class="<?php
	if ( ! empty( $foodie_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( foodie_is_blog_style_use_masonry( $foodie_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $foodie_columns ) : esc_attr( $foodie_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $foodie_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $foodie_columns )
				. ' post_layout_' . esc_attr( $foodie_blog_style[0] )
				. ' post_layout_' . esc_attr( $foodie_blog_style[0] ) . '_' . esc_attr( $foodie_columns )
	);
	foodie_add_blog_animation( $foodie_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$foodie_hover      = ! empty( $foodie_template_args['hover'] ) && ! foodie_is_inherit( $foodie_template_args['hover'] )
							? $foodie_template_args['hover']
							: foodie_get_theme_option( 'image_hover' );

	$foodie_components = ! empty( $foodie_template_args['meta_parts'] )
							? ( is_array( $foodie_template_args['meta_parts'] )
								? $foodie_template_args['meta_parts']
								: explode( ',', $foodie_template_args['meta_parts'] )
								)
							: foodie_array_get_keys_by_value( foodie_get_theme_option( 'meta_parts' ) );

	foodie_show_post_featured( apply_filters( 'foodie_filter_args_featured',
		array(
			'thumb_size' => ! empty( $foodie_template_args['thumb_size'] )
				? $foodie_template_args['thumb_size']
				: foodie_get_thumb_size(
					'classic' == $foodie_blog_style[0]
						? ( strpos( foodie_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $foodie_columns > 2 ? 'big' : 'huge' )
								: ( $foodie_columns > 2
									? ( $foodie_expanded ? 'square' : 'square' )
									: ($foodie_columns > 1 ? 'square' : ( $foodie_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( foodie_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $foodie_columns > 2 ? 'masonry-big' : 'full' )
								: ($foodie_columns === 1 ? ( $foodie_expanded ? 'huge' : 'big' ) : ( $foodie_columns <= 2 && $foodie_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $foodie_hover,
			'meta_parts' => $foodie_components,
			'no_links'   => ! empty( $foodie_template_args['no_links'] ),
        ),
        'content-classic',
        $foodie_template_args
    ) );

	// Title and post meta
	$foodie_show_title = get_the_title() != '';
	$foodie_show_meta  = count( $foodie_components ) > 0 && ! in_array( $foodie_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $foodie_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'foodie_filter_show_blog_meta', $foodie_show_meta, $foodie_components, 'classic' ) ) {
				if ( count( $foodie_components ) > 0 ) {
					do_action( 'foodie_action_before_post_meta' );
					foodie_show_post_meta(
						apply_filters(
							'foodie_filter_post_meta_args', array(
							'components' => join( ',', $foodie_components ),
							'seo'        => false,
							'echo'       => true,
						), $foodie_blog_style[0], $foodie_columns
						)
					);
					do_action( 'foodie_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'foodie_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'foodie_action_before_post_title' );
				if ( empty( $foodie_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'foodie_action_after_post_title' );
			}

			if( !in_array( $foodie_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'foodie_filter_show_blog_readmore', ! $foodie_show_title || ! empty( $foodie_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $foodie_template_args['no_links'] ) ) {
						do_action( 'foodie_action_before_post_readmore' );
						foodie_show_post_more_link( $foodie_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'foodie_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $foodie_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('foodie_filter_show_blog_excerpt', empty($foodie_template_args['hide_excerpt']) && foodie_get_theme_option('excerpt_length') > 0, 'classic')) {
			foodie_show_post_content($foodie_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $foodie_template_args['more_button'] )) {
			if ( empty( $foodie_template_args['no_links'] ) ) {
				do_action( 'foodie_action_before_post_readmore' );
				foodie_show_post_more_link( $foodie_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'foodie_action_after_post_readmore' );
			}
		}
		$foodie_content = ob_get_contents();
		ob_end_clean();
		foodie_show_layout($foodie_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
