<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package FOODIE
 * @since FOODIE 1.0.06
 */

$foodie_header_css   = '';
$foodie_header_image = get_header_image();
$foodie_header_video = foodie_get_header_video();
if ( ! empty( $foodie_header_image ) && foodie_trx_addons_featured_image_override( is_singular() || foodie_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$foodie_header_image = foodie_get_current_mode_image( $foodie_header_image );
}

$foodie_header_id = foodie_get_custom_header_id();
$foodie_header_meta = get_post_meta( $foodie_header_id, 'trx_addons_options', true );
if ( ! empty( $foodie_header_meta['margin'] ) ) {
	foodie_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( foodie_prepare_css_value( $foodie_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $foodie_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $foodie_header_id ) ) ); ?>
				<?php
				echo ! empty( $foodie_header_image ) || ! empty( $foodie_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $foodie_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $foodie_header_image ) {
					echo ' ' . esc_attr( foodie_add_inline_css_class( 'background-image: url(' . esc_url( $foodie_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( foodie_is_on( foodie_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight foodie-full-height';
				}
				$foodie_header_scheme = foodie_get_theme_option( 'header_scheme' );
				if ( ! empty( $foodie_header_scheme ) && ! foodie_is_inherit( $foodie_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $foodie_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $foodie_header_video ) ) {
		get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'foodie_action_show_layout', $foodie_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
