<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package FOODIE
 * @since FOODIE 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$foodie_copyright_scheme = foodie_get_theme_option( 'copyright_scheme' );
if ( ! empty( $foodie_copyright_scheme ) && ! foodie_is_inherit( $foodie_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $foodie_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$foodie_copyright = foodie_get_theme_option( 'copyright' );
			if ( ! empty( $foodie_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$foodie_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $foodie_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$foodie_copyright = foodie_prepare_macros( $foodie_copyright );
				// Display copyright
				echo wp_kses( nl2br( $foodie_copyright ), 'foodie_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
