<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

if ( foodie_sidebar_present() ) {
	
	$foodie_sidebar_type = foodie_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $foodie_sidebar_type && ! foodie_is_layouts_available() ) {
		$foodie_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $foodie_sidebar_type ) {
		// Default sidebar with widgets
		$foodie_sidebar_name = foodie_get_theme_option( 'sidebar_widgets' );
		foodie_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $foodie_sidebar_name ) ) {
			dynamic_sidebar( $foodie_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$foodie_sidebar_id = foodie_get_custom_sidebar_id();
		do_action( 'foodie_action_show_layout', $foodie_sidebar_id );
	}
	$foodie_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $foodie_out ) ) {
		$foodie_sidebar_position    = foodie_get_theme_option( 'sidebar_position' );
		$foodie_sidebar_position_ss = foodie_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $foodie_sidebar_position );
			echo ' sidebar_' . esc_attr( $foodie_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $foodie_sidebar_type );

			$foodie_sidebar_scheme = apply_filters( 'foodie_filter_sidebar_scheme', foodie_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $foodie_sidebar_scheme ) && ! foodie_is_inherit( $foodie_sidebar_scheme ) && 'custom' != $foodie_sidebar_type ) {
				echo ' scheme_' . esc_attr( $foodie_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="foodie_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'foodie_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $foodie_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$foodie_title = apply_filters( 'foodie_filter_sidebar_control_title', 'float' == $foodie_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'foodie' ) : '' );
				$foodie_text  = apply_filters( 'foodie_filter_sidebar_control_text', 'above' == $foodie_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'foodie' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $foodie_title ); ?>"><?php echo esc_html( $foodie_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'foodie_action_before_sidebar', 'sidebar' );
				foodie_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $foodie_out ) );
				do_action( 'foodie_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'foodie_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
