<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'foodie_mailchimp_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'foodie_mailchimp_theme_setup9', 9 );
	function foodie_mailchimp_theme_setup9() {
		if ( foodie_exists_mailchimp() ) {
			add_action( 'wp_enqueue_scripts', 'foodie_mailchimp_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'foodie_mailchimp_frontend_scripts', 10, 1 );
			add_filter( 'foodie_filter_merge_styles', 'foodie_mailchimp_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'foodie_filter_tgmpa_required_plugins', 'foodie_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'foodie_mailchimp_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('foodie_filter_tgmpa_required_plugins',	'foodie_mailchimp_tgmpa_required_plugins');
	function foodie_mailchimp_tgmpa_required_plugins( $list = array() ) {
		if ( foodie_storage_isset( 'required_plugins', 'mailchimp-for-wp' ) && foodie_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'install' ) !== false ) {
			$list[] = array(
				'name'     => foodie_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'title' ),
				'slug'     => 'mailchimp-for-wp',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'foodie_exists_mailchimp' ) ) {
	function foodie_exists_mailchimp() {
		return function_exists( '__mc4wp_load_plugin' ) || defined( 'MC4WP_VERSION' );
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue styles for frontend
if ( ! function_exists( 'foodie_mailchimp_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'foodie_mailchimp_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'foodie_mailchimp_frontend_scripts', 10, 1 );
	function foodie_mailchimp_frontend_scripts( $force = false ) {
		static $loaded = false;
		if ( ! $loaded && (
			current_action() == 'wp_enqueue_scripts' && foodie_need_frontend_scripts( 'mailchimp' )
			||
			current_action() != 'wp_enqueue_scripts' && $force === true
			)
		) {
			$loaded = true;
			$foodie_url = foodie_get_file_url( 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' );
			if ( '' != $foodie_url ) {
				wp_enqueue_style( 'foodie-mailchimp-for-wp', $foodie_url, array(), null );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'foodie_mailchimp_merge_styles' ) ) {
	//Handler of the add_filter( 'foodie_filter_merge_styles', 'foodie_mailchimp_merge_styles');
	function foodie_mailchimp_merge_styles( $list ) {
		$list[ 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( foodie_exists_mailchimp() ) {
	require_once foodie_get_file_dir( 'plugins/mailchimp-for-wp/mailchimp-for-wp-style.php' );
}

