<?php

$elements = [
	'content-elements'         => [
		'title'    => __( 'Content Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'creative-btn',
				'title'     => __( 'Creative Button', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/creative-buttons/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/content-elements/creative-buttons/',
			],
			[
				'key'       => 'team-members',
				'title'     => __( 'Team Member', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/team-members/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/team-members/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'testimonials',
				'title'     => __( 'Testimonial', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/testimonials/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/testimonials/',
			],
			[
				'key'       => 'flip-box',
				'title'     => __( 'Flip Box', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/flip-box/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/flip-box/',
			],
			[
				'key'       => 'info-box',
				'title'     => __( 'Info Box', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/info-box/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/info-box/',
			],
			[
				'key'       => 'dual-header',
				'title'     => __( 'Dual Color Heading', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/dual-color-headline/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/dual-color-headline/',
			],
			[
				'key'       => 'tooltip',
				'title'     => __( 'Tooltip', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/tooltip/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/tooltip/',
			],
			[
				'key'       => 'adv-accordion',
				'title'     => __( 'Advanced Accordion', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/advanced-accordion/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/advanced-accordion/',
				'promotion' => 'updated'
			],
			[
				'key'       => 'adv-tabs',
				'title'     => __( 'Advanced Tabs', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/advanced-tabs/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/advanced-tabs/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'feature-list',
				'title'     => __( 'Feature List', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/feature-list/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/ea-feature-list/',
			],
			[
				'key'       => 'offcanvas',
				'title'     => __( 'Offcanvas', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/offcanvas-content/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/essential-addons-elementor-offcanvas/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'advanced-menu',
				'title'     => __( 'Advanced Menu', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/advanced-menu/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/ea-advanced-menu/',
				'is_pro'    => true
			],
			[
				'key'       => 'toggle',
				'title'     => __( 'Toggle', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/content-toggle/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/content-toggle/',
				'is_pro'    => true
			],
			[
				'key'       => 'testimonial-slider',
				'title'     => __( 'Testimonial Slider', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/testimonial-slider/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/testimonial-slider/',
				'is_pro'    => true
			],
			[
				'key'       => 'static-product',
				'title'     => __( 'Static Product', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/static-product/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/static-product/',
				'is_pro'    => true
			],
			[
				'key'       => 'team-member-carousel',
				'title'     => __( 'Team Member Carousel', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/team-members-carousel/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/team-member-carousel/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'sticky-video',
				'title'     => __( 'Sticky Video', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/sticky-video/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/sticky-video/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'event-calendar',
				'title'     => __( 'Event Calendar', 'essential-addons-elementor' ),
				'demo_link' => 'https://essential-addons.com/elementor/event-calendar/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/event-calendar/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'simple-menu',
				'title'     => __( 'Simple Menu', 'essential-addons-elementor' ),
				'demo_link' => 'https://essential-addons.com/elementor/simple-menu/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/simple-menu/',
			],
			[
				'key'   => 'advanced-search',
				'title' => __( 'Advanced Search', 'essential-addons-elementor' ),
				'demo_link' => 'https://essential-addons.com/elementor/advanced-search/',
				'doc_link' => 'https://essential-addons.com/elementor/docs/advanced-search/',
				'is_pro' => true,
				'promotion' => 'new'
			],
		]
	],
	'dynamic-content-elements' => [
		'title'    => __( 'Dynamic Content Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'post-grid',
				'title'     => __( 'Post Grid', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/post-grid/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/post-grid/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'post-timeline',
				'title'     => __( 'Post Timeline', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/post-timeline/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/post-timeline/',
			],
			[
				'key'       => 'data-table',
				'title'     => __( 'Data Table', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/table/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/data-table/',
			],
			[
				'key'       => 'advanced-data-table',
				'title'     => __( 'Advanced Data Table', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/advanced-data-table/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/advanced-data-table/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'content-ticker',
				'title'     => __( 'Content Ticker', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/content-ticker/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/content-ticker/',
			],
			[
				'key'       => 'adv-google-map',
				'title'     => __( 'Advanced Google Map', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/advanced-google-map/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/advanced-google-map/',
				'is_pro'    => true,
				'setting'   => $this->pro_enabled ? [ 'id' => 'eael-googl-map-setting' ] : [],
				'promotion' => 'popular'
			],
			[
				'key'       => 'post-block',
				'title'     => __( 'Post Block', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/post-block/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/post-block/',
				'is_pro'    => true
			],
			[
				'key'       => 'post-carousel',
				'title'     => __( 'Post Carousel', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/post-carousel/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/post-carousel/',
				'is_pro'    => true
			],
			[
				'key'       => 'post-list',
				'title'     => __( 'Smart Post List', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/post-list/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/smart-post-list/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'content-timeline',
				'title'     => __( 'Content Timeline', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/content-timeline/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/content-timeline/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'dynamic-filter-gallery',
				'title'     => __( 'Dynamic Gallery', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/dynamic-gallery/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/dynamic-filterable-gallery/',
				'promotion' => 'popular',
				'is_pro'    => true
			],
			[
				'key'       => 'nft-gallery',
				'title'     => __( 'NFT Gallery', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/nft-gallery/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/ea-nft-gallery/',
				'promotion' => 'new',
			],
		]
	],
	'creative-elements'        => [
		'title'    => __( 'Creative Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'count-down',
				'title'     => __( 'Countdown', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/countdown/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/creative-elements/ea-countdown/',
			],
			[
				'key'       => 'fancy-text',
				'title'     => __( 'Fancy Text', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/fancy-text/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/fancy-text/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'filter-gallery',
				'title'     => __( 'Filterable Gallery', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/filterable-gallery/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/filterable-gallery/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'image-accordion',
				'title'     => __( 'Image Accordion', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/image-accordion/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/image-accordion/',
			],
			[
				'key'       => 'progress-bar',
				'title'     => __( 'Progress Bar', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/progress-bar/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/progress-bar/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'interactive-promo',
				'title'     => __( 'Interactive Promo', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/interactive-promo/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/interactive-promo/',
				'is_pro'    => true
			],
			[
				'key'       => 'counter',
				'title'     => __( 'Counter', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/counter/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/counter/',
				'is_pro'    => true
			],
			[
				'key'       => 'lightbox',
				'title'     => __( 'Lightbox & Modal', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/lightbox-modal/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/lightbox-modal/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'protected-content',
				'title'     => __( 'Protected Content', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/protected-content/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/ea-protected-content/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'img-comparison',
				'title'     => __( 'Image Comparison', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/image-comparison/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/image-comparison/',
				'is_pro'    => true
			],
			[
				'key'       => 'flip-carousel',
				'title'     => __( 'Flip Carousel', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/flip-carousel/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/flip-carousel/',
				'is_pro'    => true,
			],
			[
				'key'       => 'logo-carousel',
				'title'     => __( 'Logo Carousel', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/logo-carousel/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/logo-carousel/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'interactive-cards',
				'title'     => __( 'Interactive Cards', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/interactive-cards/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/interactive-cards/',
				'is_pro'    => true
			],
			[
				'key'       => 'one-page-navigation',
				'title'     => __( 'One Page Navigation', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/one-page-nav/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/one-page-navigation/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'image-hotspots',
				'title'     => __( 'Image Hotspots', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/image-hotspots/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/image-hotspots/',
				'is_pro'    => true
			],
			[
				'key'       => 'divider',
				'title'     => __( 'Divider', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/divider/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/divider/',
				'is_pro'    => true
			],
			[
				'key'       => 'image-scroller',
				'title'     => __( 'Image Scroller', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/image-scroller/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/ea-image-scroller/',
				'is_pro'    => true
			],
			[
				'key'       => 'interactive-circle',
				'title'     => __( 'Interactive Circle', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/interactive-circle/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/interactive-circle/',
				'promotion' => 'new'
			]
		]
	],
	'marketing-elements'       => [
		'title'    => __( 'Marketing Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'call-to-action',
				'title'     => __( 'Call To Action', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/call-to-action/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/call-to-action/',
			],
			[
				'key'       => 'price-table',
				'title'     => __( 'Pricing Table', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/pricing-table/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/pricing-table/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'price-menu',
				'title'     => __( 'Price menu', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/price-menu/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/price-menu/',
				'is_pro'    => true
			]
		]
	],
	'form-styler-elements'     => [
		'title'    => __( 'Form Styler Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'contact-form-7',
				'title'     => __( 'Contact Form 7', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/contact-form-7/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/contact-form-7/',
			],
			[
				'key'       => 'weforms',
				'title'     => __( 'weForms', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/weforms/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/weforms/',
			],
			[
				'key'       => 'ninja-form',
				'title'     => __( 'Ninja Form', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/ninja-forms/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/ninja-forms/',
			],
			[
				'key'       => 'gravity-form',
				'title'     => __( 'Gravity Form', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/gravity-forms/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/gravity-forms/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'caldera-form',
				'title'     => __( 'Caldera Form', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/caldera-forms/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/caldera-forms/',
			],
			[
				'key'       => 'wpforms',
				'title'     => __( 'WPForms', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/wpforms/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/wpforms/',
			],
			[
				'key'       => 'fluentform',
				'title'     => __( 'Fluent Forms', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/fluent-forms/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/fluent-form/',
			],
			[
				'key'       => 'formstack',
				'title'     => __( 'Formstack', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/formstack/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/formstack/',
			],
			[
				'key'       => 'typeform',
				'title'     => __( 'Typeform', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/typeform/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/typeform/',
				'setting'   => [
					'link' => esc_url( add_query_arg( [
						'pr_code'      => wp_hash( 'eael_typeform' ),
						'redirect_uri' => esc_url( admin_url( 'admin.php?page=eael-settings' ) )
					], esc_url( 'https://app.essential-addons.com/typeform/index.php' ) ) )
				],
			],
			[
				'key'       => 'mailchimp',
				'title'     => __( 'Mailchimp', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/mailchimp/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/mailchimp/',
				'is_pro'    => true,
				'setting'   => $this->pro_enabled ? [ 'id' => 'eael-mailchimp-setting' ] : [],
				'promotion' => 'popular'
			],
			[
				'key'       => 'login-register',
				'title'     => __( 'Login | Register Form', 'essential-addons-elementor' ),
				'demo_link' => 'https://essential-addons.com/elementor/login-register-form',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/login-register-form/',
				'setting'   => [ 'id' => 'eael-login-register-setting' ],
				'promotion' => 'popular'
			],
		]
	],
	'social-feed-elements'     => [
		'title'    => __( 'Social Feed Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'twitter-feed',
				'title'     => __( 'Twitter Feed', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/twitter-feed/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/twitter-feed/',
				'promotion' => 'updated'
			],
			[
				'key'       => 'twitter-feed-carousel',
				'title'     => __( 'Twitter Feed Carousel', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/twitter-feed/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/twitter-feed-carousel/',
				'is_pro'    => true
			],
			[
				'key'       => 'instagram-gallery',
				'title'     => __( 'Instagram Feed', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/instagram-feed/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/instagram-feed/',
				'is_pro'    => true,
				'promotion' => 'popular'
			],
			[
				'key'       => 'facebook-feed',
				'title'     => __( 'Facebook Feed', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/facebook-feed/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/facebook-feed/',
				'promotion' => 'updated'
			],
		]
	],
	'learn-dash-elements'      => [
		'title'    => __( 'LearnDash Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'learn-dash-course-list',
				'title'     => __( 'LearnDash Course List', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/learndash-course-list/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/learndash-course-list/',
				'is_pro'    => true
			]
		]
	],
	'documentation-elements'   => [
		'title'    => __( 'Documentation Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'betterdocs-category-grid',
				'title'     => __( 'BetterDocs Category Grid', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/betterdocs-category-grid/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/betterdocs-category-grid/'
			],
			[
				'key'       => 'betterdocs-category-box',
				'title'     => __( 'BetterDocs Category Box', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/betterdocs-category-box/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/betterdocs-category-box/'
			],
			[
				'key'       => 'betterdocs-search-form',
				'title'     => __( 'BetterDocs Search Form', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/betterdocs-search-form/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/betterdocs-search-form/'
			]
		]
	],
	'woocommerce-elements'     => [
		'title'    => __( 'WooCommerce Elements', 'essential-addons-for-elementor-lite' ),
		'elements' => [
			[
				'key'       => 'product-grid',
				'title'     => __( 'Product Grid', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woo-product-grid/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/woocommerce-product-grid/',
				'promotion' => 'popular'
			],
			[
				'key'       => 'woo-collections',
				'title'     => __( 'Woo Product Collections', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woocommerce-product-collections/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/ea-woo-product-collections/',
				'is_pro'    => true
			],
			[
				'key'       => 'woo-product-slider',
				'title'     => __( 'Woo Product Slider', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woo-product-slider/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/woo-product-slider/',
				'is_pro'    => true
			],
			[
				'key'       => 'woo-product-carousel',
				'title'     => __( 'Woo Product Carousel', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woo-product-carousel/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/woo-product-carousel/',
				'promotion' => 'new'
			],
			[
				'key'       => 'woo-checkout',
				'title'     => __( 'Woo Checkout', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woo-checkout/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/woo-checkout/',
				'promotion' => 'updated'
			],
			[
				'key'       => 'woo-cart',
				'title'     => __( 'Woo Cart', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woo-cart/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/woocommerce-cart/',
				'promotion' => 'new'
			],
			[
				'key'       => 'woo-product-compare',
				'title'     => __( 'Woo Product Compare', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woo-product-compare/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/woo-product-compare/'
			],
			[
				'key'       => 'woo-product-gallery',
				'title'     => __( 'Woo Product Gallery', 'essential-addons-for-elementor-lite' ),
				'demo_link' => 'https://essential-addons.com/elementor/woo-product-gallery/',
				'doc_link'  => 'https://essential-addons.com/elementor/docs/woo-product-gallery/'
			],
		]
	]
];

$elements = apply_filters( 'add_eael_elementor_addons', $elements );

?>

<div id="elements" class="eael-admin-setting-tab">
    <div class="eael-global__control mb45">
        <div class="global__control__content">
            <h4><?php _e( 'Global Control', 'essential-addons-for-elementor-lite' ); ?></h4>
            <p><?php _e( 'Use the Toggle Button to Activate or Deactivate all the Elements of Essential Addons at once.', 'essential-addons-for-elementor-lite' ); ?></p>
        </div>
        <div class="global__control__switch">
            <label class="eael-switch eael-switch--xl">
                <input data-id="eael-elements-list" id="eael-global-switch-for-element" class="eael-element-global-switch" type="checkbox">
                <span class="switch__box"></span>
            </label>
            <span class="switch__status enable"><?php _e( 'Enable All', 'essential-addons-for-elementor-lite' ); ?></span>
            <span class="switch__status disable"><?php _e( 'Disable All', 'essential-addons-for-elementor-lite' ); ?></span>
        </div>
        <div class="global__control__button">
            <button type="button" class="eael-button js-eael-settings-save"><?php _e( 'Save Settings', 'essential-addons-for-elementor-lite' ); ?></button>
        </div>
    </div>
	<?php foreach ( $elements as $key => $element ): ?>
        <div class="eael-section mb50">
            <h3 class="eael-section__header"><?php echo esc_html( $element[ 'title' ] ) ?></h3>
            <div class="eael-element__wrap">
				<?php foreach ( $element[ 'elements' ] as $item ): ?>
					<?php
					$promotion_class = ! empty( $item['promotion'] ) ? sprintf( "eael-promotion-is%s", $item['promotion'] ) : "";
					?>
                    <div class="eael-element__item <?php esc_attr_e($promotion_class); ?>">
                        <div class="element__content">
                            <h4><?php echo esc_html( $item[ 'title' ] ); ?></h4>
                            <div class="element__options">
								<?php
								if ( !empty( $item[ 'setting' ] ) ):
									$link = !empty( $item[ 'setting' ][ 'link' ] ) ? $item[ 'setting' ][ 'link' ] : '#';
									$id = !empty( $item[ 'setting' ][ 'id' ] ) ? $item[ 'setting' ][ 'id' ] : '';
									?>
                                    <a target="_blank" href="<?php echo esc_url( $link ); ?>" id="<?php echo esc_attr( $id ); ?>" class="element__icon">
                                        <i class="ea-admin-icon icon-gear"></i>
                                        <span class="tooltip-text"><?php esc_html_e( 'Setting', 'essential-addons-for-elementor-lite' ); ?></span>
                                    </a>
								<?php endif; ?>
                                <a target="_blank" href="<?php echo esc_url( $item[ 'doc_link' ] ); ?>" class="element__icon">
                                    <i class="ea-admin-icon icon-doc"></i>
                                    <span class="tooltip-text"><?php esc_html_e( 'Documentation', 'essential-addons-for-elementor-lite' ); ?></span>
                                </a>
                                <a target="_blank" href="<?php echo esc_url( $item[ 'demo_link' ] ); ?>" class="element__icon">
                                    <i class="ea-admin-icon icon-monitor"></i>
                                    <span class="tooltip-text"><?php esc_html_e( 'Demo', 'essential-addons-for-elementor-lite' ); ?></span>
                                </a>
                                <label class="eael-switch">
									<?php
									$disabled = !empty( $item[ 'is_pro' ] ) && !$this->pro_enabled ? 'disabled' : '';
									$status   = isset( $item[ 'is_pro' ] ) && !$this->pro_enabled ? 'disabled' : checked( 1, $this->get_settings( $item[ 'key' ] ), false );
									printf( '<input class="eael-widget-item eael-elements-list" id="%1$s" name="%1$s"
                                           type="checkbox" %2$s>', $item[ 'key' ], $status );
									?>
                                    <span class="switch__box <?php echo $disabled; ?>"></span>
                                </label>
                                <?php printf( "%s", ( $disabled == 'disabled') ? '<i class="ea-admin-icon icon-lock eael-lock-style"></i>' : '' ); ?>
                            </div>
                        </div>
                    </div>
				<?php endforeach; ?>
            </div>
        </div>
	<?php endforeach; ?>

    <input type="hidden" name="embedpress" value="on">
    <input type="hidden" name="woocommerce-review" value="on">
    <input type="hidden" name="career-page" value="on">
    <input type="hidden" name="crowdfundly-single-campaign" value="on">
    <input type="hidden" name="crowdfundly-organization" value="on">
    <input type="hidden" name="crowdfundly-all-campaign" value="on">
    <input type="hidden" name="better-payment" value="on">

    <div class="border__line mt30"><span></span></div>
    <div class="eael__flex justify__end mt30">
        <button type="button" class="eael-button button__themeColor js-eael-settings-save"><?php _e('Save Settings','essential-addons-for-elementor-lite'); ?></button>
    </div>
</div>

