<?php

/**
 * @package Auto-Install Free SSL
 * This package is a WordPress Plugin. It issues and installs free SSL certificates in cPanel shared hosting with complete automation.
 *
 * @author Free SSL Dot Tech <support@freessl.tech>
 * @copyright  Copyright (C) 2019-2020, Anindya Sundar Mandal
 * @license    http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License, version 3
 * @link       https://freessl.tech
 * @since      Class available since Release 3.0.0
 *
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace AutoInstallFreeSSL\FreeSSLAuto\Admin;

use AutoInstallFreeSSL\FreeSSLAuto\Acme\Factory as AcmeFactory;
use AutoInstallFreeSSL\FreeSSLAuto\Acme\AcmeV2;
use AutoInstallFreeSSL\FreeSSLAuto\Controller;
use AutoInstallFreeSSL\FreeSSLAuto\Logger;

/**
 * This is free version of this plugin. No automation.
 *
 * @since 3.0.0
 */
class GenerateSSLmanually
{
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;
    private $save_button_text;
    public $factory;
    public $logger;
	public $appConfig;
	public $return_array_step1;
	/**
	 * @var false|mixed|void
	 */
	private $plan_selected;

	/**
     * Start up
     */
    public function __construct()
    {
	    if (!defined('ABSPATH')) {
		    die(__( "Access Denied", 'auto-install-free-ssl' ));
	    }

        //Add bootstrap CSS
        //wp_enqueue_style('aifs_bootstrap_css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css');

	    //Add bootstrap JS

        $this->plan_selected = get_option('aifs_plan_selected');

        $this->options = get_option('aifs_generate_ssl_manually') ? get_option('aifs_generate_ssl_manually') : add_option('aifs_generate_ssl_manually');
        
        //hook if the user selected free plan
        if (aifs_is_free_version()) {
            add_action('admin_menu', array( $this, 'add_generate_ssl_manually_menu' ));
            add_action('admin_init', array( $this, 'generate_ssl_manually_page_init' ));
	        add_action( 'admin_init', array( $this, 'download_http01_challenge_file_handler' ) );
	        //add_action( 'admin_init', array( $this, 'generate_ssl_step_3' ) );
        }
        
        $this->factory = new Factory();
	    $this->appConfig = aifs_get_app_settings();
	    $this->logger = new Logger();

        //$this->save_button_text = __("Generate Free SSL", 'auto-install-free-ssl');
	    $this->save_button_text = __("Next Step", 'auto-install-free-ssl') . "&nbsp;&nbsp;>>";

	    $date = new \DateTime();
	    $this->return_array_step1 = get_option('aifs_return_array_step1_manually') ? get_option('aifs_return_array_step1_manually') : add_option('aifs_return_array_step1_manually');

	    if(is_array($this->return_array_step1) && ($date->getTimestamp() >= strtotime($this->return_array_step1['response']['expires'])) && (!isset($this->return_array_step1['ssl_cert_generated']) || !$this->return_array_step1['ssl_cert_generated'])){
		    //reset option 
	        unset($this->return_array_step1);
		    update_option( 'aifs_return_array_step1_manually', $this->return_array_step1 );
		    wp_redirect(menu_page_url('aifs_generate_ssl_manually'), 301);
	    }
    }
    
    /**
     * Add the sub menu
     */
    public function add_generate_ssl_manually_menu()
    {
        add_submenu_page('auto_install_free_ssl', __("Generate SSL Manually Page", 'auto-install-free-ssl'), __("Generate SSL", 'auto-install-free-ssl'), 'manage_options', 'aifs_generate_ssl_manually', array( $this, 'create_generate_ssl_manually_admin_page' ));
    }
       
    
    /**
     * Options page callback
     */
    public function create_generate_ssl_manually_admin_page()
    {
	    $tos = false;

	    //$this->logger->clean_log_directory();

        if (isset($_GET['settings-updated']) && $_GET['settings-updated'] === 'true') {
            /**
             * Check if TOS selected
             */

            if(isset($this->options['agree_to_le_terms']) && isset($this->options['agree_to_freessl_tech_tos_pp'])){
	            $tos = true;
            }
            /*else{
	            $tos = false;
            }*/

            //Validate output
            if (!$tos) {
                ?>
                <div style="background: #ff0000; color: #ffffff; padding: 2px; margin-top: 3%;">
                  	<p style="margin-left: 15px; font-size: 1.1em;">
                  		<?= __("Oops! Please agree to both Terms & Conditions and try again.", 'auto-install-free-ssl') ?>
                  	</p>          	
              	</div>
                <?php
            }
            else{

                $this->generate_ssl_step_1();

                /*//Call Step 2
                $this->generate_ssl_step_2();

	            $this->generate_ssl_step_3();*/

                //wp_redirect(menu_page_url('auto_install_free_ssl').'&settings-updated=true', 301);
            }

        } ?>

        <div class="wrap">

	        <?= aifs_header() ?>

            <table style="width: 100%; margin-bottom: 2%;">
                <tr>
                    <td class="card block-body" style="width: 55%; padding-top: 1%; padding-bottom: 2%; padding-left: 2%;">

                    <?php
                    if(is_array($this->return_array_step1) && isset($this->return_array_step1['ssl_cert_generated']) && $this->return_array_step1['ssl_cert_generated']){
	                    $heading = __("Free SSL Certificate was Generated", 'auto-install-free-ssl');
                    }
                    else{
	                    $heading = __("Generate Free SSL Certificate", 'auto-install-free-ssl');
                    }

                    echo '<h1 style="color: #076507; text-align: center;">' . $heading . '</h1>';
                    echo '<h3 style="color: #076507; text-align: center;">for ' . aifs_get_domain() . '</h3>';

                    $aifs_current_step_number = 0;

                    if(!$tos && !isset($this->return_array_step1['current_step_number']) && !isset( $_POST['aifs_challenge_type'] )) {
	                    //echo "<h2 style='color: black'>Step 1 of 3</h2>";
	                    $aifs_current_step_number = 1;

                        echo $this->progress_bar();

                        echo '<form method="post" action="options.php">';

	                    settings_fields( 'aifs_generate_ssl_manually_group' );
	                    do_settings_sections( 'aifs_generate_ssl_manually_admin' );

	                    $confirmation_text = __( "Are you ready to start?", 'auto-install-free-ssl' );
	                    submit_button( $this->save_button_text, 'button-primary button-hero', 'submit', false , 'onclick="return aifs_confirm_initiate(\''. $confirmation_text .'\')"');

	                    //echo '<a href="' . menu_page_url( 'auto_install_free_ssl', false ) . '" id="aifs-cancel" class="page-title-action button">' . __( "Cancel", 'auto-install-free-ssl' ) . '</a>';

	                    echo '</form>';
                    }

                    if($this->generate_ssl_all_domains_verified_already() || isset( $_POST['aifs_challenge_type']) || (is_array($this->return_array_step1) && $this->return_array_step1['current_step_number'] == 3))
                    {
	                    $aifs_current_step_number = 3;
	                    //Call Step 3
	                    $this->generate_ssl_step_3();
                    }
                    elseif($tos || (is_array($this->return_array_step1) && $this->return_array_step1['current_step_number'] == 2))
                    {
	                    $aifs_current_step_number = 2;
	                    //Call Step 2
	                    $this->generate_ssl_step_2();
                    }

                    ?>


                    </td>

                    <?php
                    /*
                     * Show here only if it is Step 3 and an SSL is installed (if required, check Expiry date of SSL directory vs installed SSL) and aifs_force_ssl is not set or is zero.
                     *
                     * In all other cases, show the documentation (text and/or video) relevant to that Step
                     */

                    if($aifs_current_step_number == 3 && isset($this->return_array_step1['ssl_cert_generated']) && $this->return_array_step1['ssl_cert_generated']){ ?>
                        <td style="width: 2%;"></td>
                        <td class="card block-body" style="padding-left: 1.5%;">
	                        <?php if(isset($this->appConfig['is_cpanel']) && $this->appConfig['is_cpanel']){ ?>
                                <h3><?= __( "cPanel: How to Install SSL Certificate", 'auto-install-free-ssl' ) ?></h3>

                                <!-- <iframe width="100%" height="251" src="https://www.youtube.com/embed/9x-kMz6Eo1E?rel=0" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> -->
                                <div style="padding:53.33% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/745428583?h=73867938d9&title=0&byline=0&portrait=0" style="position:absolute;top:0;left:0;width:100%;height:100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
                                <br />
	                        <?php } ?>

                            <?php if($this->factory->is_plesk()){ ?>
                                <h3 id="plesk"><?= __( "Plesk: How to Install SSL Certificate", 'auto-install-free-ssl' ) ?></h3>

                                <!-- <iframe width="100%" height="251" src="https://www.youtube.com/embed/o4_N4QRVd48?rel=0" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> -->
                                <div style="padding:53.33% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/745440419?h=347619a800&title=0&byline=0&portrait=0" style="position:absolute;top:0;left:0;width:100%;height:100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
                                <br />
                            <?php } ?>

	                        <?php if($this->factory->control_panel_is_unknown()){ ?>
                                <h3 style="line-height: 2em;"><?= __( "Please log in to your web hosting control panel to install the SSL certificate", 'auto-install-free-ssl' ) ?></h3>
                                <p><?= __( "Most web hosting companies provide an option to install SSL certificates. Please contact your web hosting provider if you are not aware of this option.", 'auto-install-free-ssl' ) ?></p>
	                        <?php } ?>

                            <p><?= __( "Did you know automated SSL Certificate installation is possible with our Premium Version?" ) ?></p>
                            <p><?= sprintf(__( "Do you need automation for all the steps? %sUpgrade to the %sPremium Version%s.", 'auto-install-free-ssl' ), '<br />', '<a href="'. aifssl_fs()->get_upgrade_url(WP_FS__PERIOD_ANNUALLY) .'">', '</a>') ?></p>

                        </td>
                    <?php } ?>

                </tr>

            </table>

            <div class="overlay"></div>
            <div class="spanner">
                <div class="loader"></div>
                <p class="loader_text"><?= __( "Processing, please wait ...", 'auto-install-free-ssl' ) ?></p>
            </div>

            <?php $this->pro_version_promotion(); ?>

            <?php
            if(!get_option('aifs_force_ssl') && $aifs_current_step_number == 3 && isset($this->return_array_step1['ssl_cert_generated']) && $this->return_array_step1['ssl_cert_generated']){ ?>
            <table style="width: 100%; margin-top: 2%;" id="force-https">
                <tr>
	                <?php
	                $forcehttps = new ForceSSL();
					echo $forcehttps->force_ssl_ui();
	                ?>
                </tr>
            </table>
            <?php } ?>

	        <?= aifs_powered_by() ?>
        </div>
        <?php
    }


	/**
	 * Promotion of Pro version
	 */
    public function pro_version_promotion(){
        ?>
            <table style="width: 100%; margin-top: 2%;" id="comparison">
                <tr>
                    <td class="card block-body" style="width: 100%; padding: 0.5% 1.5% 0.5% 1.5%; background-color: #adff2f;" colspan="2">
                        <p style="color: black; font-size: 1.2em;"><?= sprintf(__("Hello %s! Why waste your valuable time with manual SSL renewal every 60 days? Enjoy %s automation with our PRO version.", 'auto-install-free-ssl'), aifs_admin_first_name(), ($this->factory->is_cpanel()? "100%" : "")) ?></p>
                    </td>
                </tr>
                <tr>
                    <td class="card block-body" style="width: 50%; padding-left: 1.5%;">
                        <h3><?= __( "Comparison of Free vs Pro Version", 'auto-install-free-ssl' ) ?></h3>
                        <p style="color: green;">&nbsp;</p>
                        <table style="width: 100%; margin-top: 2%;" border="1" cellspacing="0">
                            <thead>
                                <tr>
                                    <th id="columnname" class="manage-column column-columnname" scope="col"><?= __( "Feature", 'auto-install-free-ssl' ) ?></th>
                                    <th id="columnname" class="manage-column column-columnname" scope="col"><?= __( "Free", 'auto-install-free-ssl' ) ?></th>
                                    <th id="columnname" class="manage-column column-columnname pro-version" scope="col"><?= __( "Pro", 'auto-install-free-ssl' ) ?></th>
                                    <th id="columnname" class="manage-column column-columnname pro-version" scope="col"><?= __( "Pro Unlimited", 'auto-install-free-ssl' ) ?></th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr class="alternate">
                                    <td scope="row"><?= __( "Domain Verification", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "Manual", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Automatic", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Automatic", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                                <tr>
                                    <td><?= __( "Generate SSL", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "Manual", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __("Automatic", 'auto-install-free-ssl') ?></td>
                                    <td class="pro-version"><?= __("Automatic", 'auto-install-free-ssl') ?></td>
                                </tr>
                                <tr class="alternate">
                                    <td><?= __( "SSL Installation", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "Manual", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __("Automatic", 'auto-install-free-ssl') ?></td>
                                    <td class="pro-version"><?= __("Automatic", 'auto-install-free-ssl') ?></td>
                                </tr>
                                <tr>
                                    <td><?= __( "Cron Job", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Automatic", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Automatic", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                                <tr class="alternate">
                                    <td><?= __( "SSL Renewal", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "Manual", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Automatic", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Automatic", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                                <tr>
                                    <td><?= __( "Time Required to Set Up", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "20+ Min (per 60 days)", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "1 Min (once)", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "1 Min (once)", 'auto-install-free-ssl' ) ?> <sup>*</sup></td>
                                </tr>
                                <tr class="alternate">
                                    <td><?= __( "Wildcard SSL", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Yes", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                                <tr>
                                    <td><?= __( "Multisite Support", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Yes", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                                <tr class="alternate">
                                    <td><?= __( "SSL Expiration Chance", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "High", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                                <tr>
                                    <td><?= sprintf( __( "One installation works on all%s websites of a cPanel", 'auto-install-free-ssl' ), '<br />') ?></td>
                                    <td><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "No", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "Yes", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                                <tr class="alternate">
                                    <td><?= __( "Support", 'auto-install-free-ssl' ) ?></td>
                                    <td><?= __( "Forum", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "E-mail", 'auto-install-free-ssl' ) ?></td>
                                    <td class="pro-version"><?= __( "E-mail/Phone", 'auto-install-free-ssl' ) ?></td>
                                </tr>
                            </tbody>
                        </table>

                        <p style="text-align: right;"><a href="<?= admin_url('admin.php?page=auto_install_free_ssl-pricing') ?>" class="button button-primary"><?= __( "Upgrade to Pro", 'auto-install-free-ssl' ) ?></a></p>
	                    <p>* <em><?= sprintf(__( "If you need the plugin to work on all websites in the same %s, you need %s minutes (once).", 'auto-install-free-ssl' ), ((isset($this->appConfig['is_cpanel']) && $this->appConfig['is_cpanel']) ? 'cPanel' : 'hosting'), ((isset($this->appConfig['is_cpanel']) && $this->appConfig['is_cpanel']) ? '9' : '10')) ?></em></p>
                    </td>

                    <td class="card block-body" style="width: 50%; padding-left: 1.5%;">
                        <h3><?= __( "One-Click Automation of Free SSL on cPanel [1:42 Min]", 'auto-install-free-ssl' ) ?></h3>
                        <p style="color: green;"><?= __( "Video Tutorial of the Pro / Unlimited Version.", 'auto-install-free-ssl' ) ?></p>

                       <!-- <iframe width="100%" height="281" src="https://www.youtube.com/embed/XYgNPcj_zaM?rel=0" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe> -->
                        <div style="padding:53.33% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/745390051?h=94ba682137&title=0&byline=0&portrait=0" style="position:absolute;top:0;left:0;width:100%;height:100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
                    </td>
                </tr>
            </table>
        <?php
    }


    /**
     * Register and add settings
     */
    public function generate_ssl_manually_page_init()
    {
        register_setting(
            'aifs_generate_ssl_manually_group', // Option group
            'aifs_generate_ssl_manually', // Option name
            array( $this, 'sanitize' ) // Sanitize
        );

        add_settings_section(
            'aifs_generate_ssl_section_id', // Section ID
            "",
            array( $this, 'print_section_info' ), // Callback
            'aifs_generate_ssl_manually_admin' // Page
        );

        if(get_option('aifs_is_admin_email_invalid')){
	        add_settings_field(
		        'admin_email',
		        sprintf(__("Admin email %s(required)%s", 'auto-install-free-ssl'), '<sup>', '</sup>'),
		        array( $this, 'admin_email_callback' ),
		        'aifs_generate_ssl_manually_admin',
		        'aifs_generate_ssl_section_id'
	        );
        }

	    add_settings_field(
		    'agree_to_le_terms',
		    sprintf(__("%sI agree to the %sLet's Encrypt Subscriber Agreement %s(required)%s", 'auto-install-free-ssl'), '<div id="agree_to_le_terms">', '<a href="https://letsencrypt.org/documents/LE-SA-v1.3-September-21-2022.pdf" target="_blank">', '</a> <sup>', '</sup></div>'),
		    array( $this, 'agree_to_le_terms_callback' ),
		    'aifs_generate_ssl_manually_admin',
		    'aifs_generate_ssl_section_id'
	    );

	    add_settings_field(
		    'agree_to_freessl_tech_tos_pp',
		    sprintf(__("I agree to the FreeSSL.tech %sTerms of Service%s and %sPrivacy Policy %s(required)%s", 'auto-install-free-ssl'), '<a href="https://freessl.tech/terms-of-service" target="_blank">', '</a>', '<a href="https://freessl.tech/privacy-policy" target="_blank">', '</a> <sup>', '</sup>'),
		    array( $this, 'agree_to_freessl_tech_tos_pp_callback' ),
		    'aifs_generate_ssl_manually_admin',
		    'aifs_generate_ssl_section_id'
	    );

    }

	/**
	 * Sanitize each setting field as needed
	 *
	 * @param array $input (Contains all settings fields as array keys)
	 *
	 * @return array
	 */
    public function sanitize($input)
    {
        $new_input = array();

        if (isset($input['agree_to_le_terms'])) {
            $new_input['agree_to_le_terms'] = sanitize_text_field($input['agree_to_le_terms']);
        }

	    if (isset($input['agree_to_freessl_tech_tos_pp'])) {
		    $new_input['agree_to_freessl_tech_tos_pp'] = sanitize_text_field($input['agree_to_freessl_tech_tos_pp']);
	    }

	    if(get_option('aifs_is_admin_email_invalid') && isset($input['admin_email'])){
	        $basic_settings = get_option('basic_settings_auto_install_free_ssl');
		    $basic_settings['admin_email'][0] = sanitize_email($input['admin_email']);
		    update_option('basic_settings_auto_install_free_ssl', $basic_settings);

		    update_option('admin_email', sanitize_email($input['admin_email']));
	    }

        //Set agree_to_le_terms, agree_to_freessl_tech_tos_pp if not set and if NOT multi domain
        /*if(!(bool)get_option('aifs_is_multi_domain')){

            $basic_settings = get_option('basic_settings_auto_install_free_ssl') ? get_option('basic_settings_auto_install_free_ssl') : add_option('basic_settings_auto_install_free_ssl');

            if(!isset($basic_settings['agree_to_le_terms']) || !isset($basic_settings['agree_to_freessl_tech_tos_pp'])){
                $basic_settings['agree_to_le_terms'] = true;
                $basic_settings['agree_to_freessl_tech_tos_pp'] = true;
                update_option('basic_settings_auto_install_free_ssl', $basic_settings);
            }
        }*/
                
        return $new_input;
    }

    /**
     * Print the Section text
     */
    public function print_section_info()
    {
	    echo $this->factory->domain_alias_availability_text();

            //echo "<br />";

            echo "<style>
                    .form-table{
                        margin-top: 0%;
                    }
                    p.submit{
                        margin-top: 0%;
                    }
                </style>";
        //}

        //echo "<br /><br />";

    }

	/**
	 * agree_to_le_terms
	 */
	public function agree_to_le_terms_callback()
	{
		?>
        <div id="agree_to_le_terms">
            <input type="checkbox" id="agree_to_le_terms" name="aifs_generate_ssl_manually[agree_to_le_terms]" required="required"<?php echo (isset($this->options['agree_to_le_terms']) && 'on' === $this->options['agree_to_le_terms']) ? ' checked' : null; ?> />
        </div>
		<?php
	}

	/**
	 * agree_to_freessl_tech_tos_pp
	 */
	public function agree_to_freessl_tech_tos_pp_callback()
	{
		?>
        <input type="checkbox" id="agree_to_freessl_tech_tos_pp" name="aifs_generate_ssl_manually[agree_to_freessl_tech_tos_pp]" required="required"<?php echo (isset($this->options['agree_to_freessl_tech_tos_pp']) && 'on' === $this->options['agree_to_freessl_tech_tos_pp']) ? ' checked' : null; ?> />

		<?php
	}


	/**
	 * admin_email
	 */
	public function admin_email_callback()
	{
		//Get current user details
		global $current_user;
		get_currentuserinfo();

		printf(
			'<input type="email" id="admin_email" name="aifs_generate_ssl_manually[admin_email]" required="required" value="%s" />',
			 $current_user->user_email
		);
	}


	public function generate_ssl_step_1(){

	    //return false;

	    if(!isset($this->return_array_step1['current_step_number'])){

		    //$this->logger->clean_log_directory();

			$installed_hosts = null;
			$homedir         = $this->appConfig['homedir'];
			/*$cPanel = [
				'is_cpanel' => $this->appConfig['is_cpanel'],
			];*/
			$cPanel        = [
				'is_cpanel' => false
			];

			/*$all_domains   = $this->appConfig['all_domains'];
			$single_domain = $all_domains[0];*/
		    $domain = aifs_get_domain(true);

		    $single_domain = [
				    'domain' => $domain,
				    'serveralias' => 'www.'.$domain,
				    'documentroot' => $this->factory->document_root_wp()
            ];

			$controller = new Controller();
			//domains array
			$domains_array = $controller->domainsArray( $single_domain, $this->appConfig['domains_to_exclude'] );

			/*if(!is_array($this->appConfig['admin_email'])){
				$this->appConfig['admin_email'] = [get_option('admin_email')];
			}*/

			$freessl = new AcmeV2( $homedir . DS . $this->appConfig['certificate_directory'], $this->appConfig['admin_email'], $this->appConfig['is_staging'], $this->appConfig['dns_provider'], $this->appConfig['key_size'], $cPanel, $this->appConfig['server_ip'] );

			if ( count( $domains_array ) > 0 ) {
				//Start the process to generate SSL
				$this->logger->log( sprintf(__("Generating SSL for %s", 'auto-install-free-ssl'), $domains_array[0]) );
				$this->logger->log( __( "Domains array given below: ", 'auto-install-free-ssl' ));

				if ( $this->logger->is_cli() ) {
					$this->logger->log( print_r( $domains_array, true ) );
				} else {
					$this->logger->log( '<pre>' . print_r( $domains_array, true ) . '</pre>' );
				}

				try {
					//$freessl->obtainSsl($domains_array, $single_domain['documentroot'], false, $this->appConfig['country_code'], $this->appConfig['state'], $this->appConfig['organization']);

					$return_array_step1 = $freessl->step1GetAuthenticationTokens( $domains_array, $single_domain['documentroot'], false, $this->appConfig['country_code'], $this->appConfig['state'], $this->appConfig['organization'] );
					$return_array_step1['domains_array'] = $domains_array;
					$return_array_step1['current_step_number'] = 2;

					/*if ( ! get_option( 'aifs_return_array_step1_manually' ) ) {
						add_option( 'aifs_return_array_step1_manually', $return_array_step1 );
					} else {*/
					update_option( 'aifs_return_array_step1_manually', $return_array_step1 );
					/*}*/
					$this->return_array_step1 = $return_array_step1;

				} catch ( \Exception $e ) {
					$this->logger->log_v2( 'error', $e->getMessage() );
					$this->logger->log_v2( 'error', $e->getTraceAsString(), [ 'event' => 'exit' ] );
				}
			}
		}
	}


	public function generate_ssl_step_2() {

		/*echo "<pre>";
		print_r($this->return_array_step1);
		echo "</pre>";*/

	    $return_array_step1 = $this->return_array_step1;

        /* In DNS-01 display this suggestion

            $suggestion = "<p style='color: red;'><br /><strong>We suggest using HTTP-01 challenge for this domain. It is faster than DNS-01 in most use cases.</strong></p>

                           <p>Moreover, all DNS service providers don't let you set multiple TXT records for the same hostname. Please contact your DNS service provider to ensure if they support multiple TXT records for the same hostname.</p>";
         *
         */

        //Get the active tab from the $_GET param
        $default_tab = "http-01";
        $tab = isset($_GET['tab']) ? $_GET['tab'] : $default_tab;

		echo $this->progress_bar(2);
        ?>
        <!-- <h2 style='color: black'>Step 2 of 3</h2> -->

        <p style="font-size: large; text-align: center;"><?= __( "Please complete any one from HTTP-01 and DNS-01 challenges to verify your domain /subdomain ownership.", 'auto-install-free-ssl' ) ?></p>
        <!-- Tabs start -->
        <br />

        <!--
        <nav class="nav-tab-wrapper">
            <a href="?page=aifs_generate_ssl_manually" class="nav-tab <?php if($tab===null):?>nav-tab-active<?php endif; ?>"><?= __( "HTTP-01", 'auto-install-free-ssl' ) ?></a>
            <a href="?page=aifs_generate_ssl_manually&tab=dns-01" class="nav-tab <?php if($tab==='dns-01'):?>nav-tab-active<?php endif; ?>"><?= __( "DNS-01", 'auto-install-free-ssl' ) ?></a>
        </nav>

        <div class="tab-content"> -->
        <?php

        //if($tab == 'http-01'){
            ?>
        <table style="width: 100%; margin-bottom: 1%;">
        <tr>
        <td class="card block-body" style="width: 49%; padding-top: 1%; padding-bottom: 2%; padding-left: 2%;">
	        <span style="font-size: large; font-weight: bold;"><?= __( "HTTP-01", 'auto-install-free-ssl' ) ?></span>
            <!-- <span style="font-weight: bold; float: right;"><span class="dashicons dashicons-format-video"></span>
		    <?php if(!isset($this->appConfig['is_cpanel']) || !$this->appConfig['is_cpanel']){ ?>
                <a href="https://www.youtube.com/watch?v=SaFgDjlqA9c" target="_blank"><?= __( "Video", 'auto-install-free-ssl' ) ?></a></span> -->
            <?php }else{ ?>
                <a href="https://www.youtube.com/watch?v=FYoob-hkEZg" target="_blank"><?= __( "Video", 'auto-install-free-ssl' ) ?></a></span> -->
	        <?php } ?>

            <hr /><br />

            <p><strong><?= __( "1.", 'auto-install-free-ssl' ) ?></strong> <?= __( "Please open an FTP client (e.g. FileZilla) or File Manager of your web hosting control panel.", 'auto-install-free-ssl' ) ?></p>

            <p><strong><?= __( "2.", 'auto-install-free-ssl' ) ?></strong> <?= sprintf(__("Browse to the document root of %s. Create a directory %s and create another directory %s inside the %s directory.", 'auto-install-free-ssl'), ('<em>' . key($return_array_step1['domain_data']) . '</em>'), '<strong>.well-known</strong>', '<strong>acme-challenge</strong>', '<strong>.well-known</strong>') ?><?= aifs_server_software() == 'ms-iis' ? " " . __( "If you face any issues (e.g., 'Invalid path specified') creating directories, create 'Virtual Directory' instead.", 'auto-install-free-ssl' ) : "" ?></p>

            <p><strong><?= __( "3.", 'auto-install-free-ssl' ) ?></strong> <?= __( "Download the following HTTP-01 challenge files:", 'auto-install-free-ssl' ) ?></p>

            <div class="challenge-files">
            <?php
	        ///echo count($return_array_step1['domain_data']) . " domains to verify.<br />";
            $n = 1;
            $file_url = wp_nonce_url( get_site_url().$_SERVER['REQUEST_URI'], 'aifs_challenge_http', 'aifschallengehttp' )."&domain=";

            $challenge_file_links = [];

            //$uri = "http://${domain}/.well-known/acme-challenge/".$challenge['token'];

            foreach ($return_array_step1['domain_data'] as $domain => $data) {
                if(!$data['verified']) {
	                echo "<pre>";
	                echo "<a href='" . $file_url . $domain . "'><span class='dashicons dashicons-download'></span>&nbsp;" . __( "Challenge File", 'auto-install-free-ssl' ) . " $n</a>";
	                echo "</pre>";
	                $challenge_file_links[] = "http://$domain/.well-known/acme-challenge/" . $data['challenge']['token'];
	                $n ++;
                }
	        }

	        /*foreach ($return_array_step1['domain_data'] as $domain => $data) {
		        echo "<strong>$domain</strong><br />";
		        echo "<pre>";
		        print_r($data['http-01']);
		        echo "</pre><br /><br />";
	        }*/
	        ?>
            </div>

            <p><strong><?= __( "4.", 'auto-install-free-ssl' ) ?></strong> <?= __( "Upload the above-downloaded challenge files into the 'acme-challenge' directory (mentioned in serial number 2).", 'auto-install-free-ssl' ) ?><?= aifs_server_software() == 'ms-iis' ? " " . __( "If you face any issues uploading files, create files with the same file name and content.", 'auto-install-free-ssl' ) : "" ?></p>

            <!-- Use foreach to avoid blank link -->
            <p><br /><?= __( "Uploaded files should be available at", 'auto-install-free-ssl' ) ?> </p>

            <?php
                /*$n = 1;
                foreach ($challenge_file_links as $link){
                    echo "<a href='$link' target='_blank'> Link $n</a>, ";
                }*/

                if(isset($challenge_file_links[0])){
	                $link = $challenge_file_links[0];
	                echo "<a href='$link' target='_blank'> " . __( "Link 1", 'auto-install-free-ssl' ) . "</a> ";
                }

                if(isset($challenge_file_links[1])){
                    $link = $challenge_file_links[1];
                    echo __( "and", 'auto-install-free-ssl' ) . " <a href='$link' target='_blank'> " . __( "Link 2", 'auto-install-free-ssl' )."</a> ";
                }

                $code = '<?xml version="1.0" encoding="UTF-8"?>
<configuration>
    <system.webServer>
        <staticContent>
            <mimeMap fileExtension="." mimeType="text/plain" />
        </staticContent>
    </system.webServer>
</configuration>';

            ?>
            .</p>

            <p><?= __( "The content of the above links should EXACTLY match the content of the downloaded files.", 'auto-install-free-ssl' ) ?><?= aifs_server_software() == 'ms-iis' ? " " . sprintf( __( "If the above links display errors, create a %s file inside the %s directory and paste the following content into it: ", 'auto-install-free-ssl' ), '<strong>web.config</strong>', '.well-known') . '<pre><code>'.htmlspecialchars($code).'</code></pre>' : "" ?></p>

            <p><br /><em><?= __( "Is everything okay? Now click the button below.", 'auto-install-free-ssl' ) ?></em></p>

        <?php echo $this->verify_domain_form(); ?>
        </td>

            <td class="" style="width: 2%;"></td>

        <td class="card block-body" style="width: 49%; padding-top: 1%; padding-bottom: 2%; padding-left: 2%;">
        <?php
        //}
        //elseif($tab == 'dns-01'){
	        $registeredDomain = getRegisteredDomain( aifs_get_domain(true) );
	        ?>
            <span style="font-size: large; font-weight: bold;"><?= __( "DNS-01", 'auto-install-free-ssl' ) ?></span><hr /><br />
            <p><strong><?= __( "1.", 'auto-install-free-ssl' ) ?></strong> <?= __( "Please log in to your DNS service provider's account for", 'auto-install-free-ssl' ) ?> <strong><em><?= $registeredDomain ?></em></strong> <?= __( "and add the TXT records given below:", 'auto-install-free-ssl' ) ?></p>
	        <?php
	        $set_no = "A";
	        foreach ($return_array_step1['domain_data'] as $domain => $data) {
		        if(!$data['verified']) {
			        echo "<br /><p><u>".__( "Record Set", 'auto-install-free-ssl' )." $set_no</u></p>";
			        echo "<p>".__( "TXT record name/host:", 'auto-install-free-ssl' )." <strong>" . $data['dns-01']['dns_txt_name'] . "</strong></p>";
			        echo "<p>".__( "TXT record value:", 'auto-install-free-ssl' )." <strong>" . $data['dns-01']['dns_txt_record'] . "</strong></p>";
			        $set_no = "B";
		        }
	        }
	        ?>

            <p><br /><?= sprintf(__("TTL (Time to Live) for both: %s1 second%s recommended. Otherwise, the minimum value supported by your DNS service provider.", 'auto-install-free-ssl'), '<strong>', '</strong>') ?></p>

            <p><br /><strong><?= __( "2.", 'auto-install-free-ssl' ) ?></strong> <?= sprintf(__("Please wait %sat least%s 15 minutes for the above-mentioned DNS records to propagate and then %sclick the button below.", 'auto-install-free-ssl'), '<strong>', '</strong>', '<em>') ?></em></p>


	        <?php
	        /*foreach ($return_array_step1['domain_data'] as $domain => $data) {
		        echo "<strong>$domain</strong><br />";
		        echo "<pre>";
		        print_r($data['dns-01']);
		        echo "</pre><br /><br />";
	        }*/

	        echo $this->verify_domain_form("dns-01");
        //}

        ?>
        </td>
        </tr>
        </table>
        <!-- </div> -->
        <!-- Tabs end -->

        <?php
            /*echo "<pre>";
            print_r($return_array_step1);
            echo "</pre>";*/

	}


	public function verify_domain_form($challenge_type = "http-01"){
		$html = '<form method="post" action="'.admin_url('admin.php?page=aifs_generate_ssl_manually').'">	
        			 <input type="hidden" name="aifs_challenge_type" value="'.$challenge_type.'" />'.
		        wp_nonce_field('aifsverifydomain', 'aifs_verify_domain', false, false);

        $confirmation_text = sprintf(__("Are you sure you have completed %s challenges?", 'auto-install-free-ssl'), strtoupper($challenge_type));

        //$button_text = __( 'Verify Domain &amp; Get SSL', 'auto-install-free-ssl' );
		$button_text = sprintf( __( "Verify Domain %s &amp; Generate Free SSL", 'auto-install-free-ssl' ), "(".strtoupper($challenge_type).")");
        $css_class = "button button-primary button-hero";

		$html .=	 '<button type="submit" name="aifs_submit" class="'.$css_class.'" onclick="return aifs_confirm(\''. $confirmation_text .'\')">'. $button_text .'</button>
      			</form>';

		return $html;

	}


	/**
	 * Download HTTP-01 challenge file handler
	 */
	public function download_http01_challenge_file_handler(){

		//initialize the Acme Factory class
		$acmeFactory = new AcmeFactory($this->appConfig['homedir'].'/'.$this->appConfig['certificate_directory'], $this->appConfig['acme_version'], $this->appConfig['is_staging']);

		if ( isset( $_GET['aifschallengehttp'] ) ) {
			if ( !wp_verify_nonce( $_GET['aifschallengehttp'], 'aifs_challenge_http' ) ) {
				wp_die(__( "Access Denied", 'auto-install-free-ssl' ));
			}

            $domain = $_GET['domain'];
			$file_name = $this->return_array_step1['domain_data'][$domain]['http-01']['file_name'];
			$file_content = $this->return_array_step1['domain_data'][$domain]['http-01']['payload'];
			$domain_path = $acmeFactory->getDomainPath($domain);
			$file_path = $domain_path . DS . $file_name;

			if (!is_dir($domain_path)) {
				@mkdir($domain_path, 0700, true);
			}

			file_put_contents($file_path, $file_content);

			$factory = new Factory();
			$factory->download_file($file_path, $file_name, true);

		}

	}


	public function generate_ssl_step_3(){

		if ( isset( $_POST['aifs_challenge_type'] ) && !wp_verify_nonce($_POST['aifs_verify_domain'], 'aifsverifydomain') ) {
			wp_die(__( "Access Denied", 'auto-install-free-ssl' ));
		}
		else {
			$home_options = new HomeOptions();

			//echo "<h2 style='color: black'>Step 3 of 3</h2>";

		    if(isset($this->return_array_step1['ssl_cert_generated']) && $this->return_array_step1['ssl_cert_generated']){
			    echo $this->progress_bar(3);

			    echo "<p style='font-weight: bold;'>" . sprintf(__("SSL certificate already issued to %s. Please download it from the links given below.", 'auto-install-free-ssl'), ("<em>" . $this->return_array_step1['domains_array'][0] . "</em>")) . "</p>";

		        echo $home_options->single_domain_ssl_data();

		        echo '<div id="ssl_renewal_form">';
                echo "<br />". $this->regenerate_ssl_form();
                echo "</div>";

			    //Display reset/renew SSL button to restart from step 1
			     /*$this->return_array_step1['current_step_number'] = 2;
			     unset($this->return_array_step1['ssl_cert_generated']);
			     update_option( 'aifs_return_array_step1_manually', $this->return_array_step1 );*/

			    /*echo "<pre>";
			    print_r($this->return_array_step1);
			    echo "</pre>";*/

		    }
		    else {
		        //return false;
			    $homedir = $this->appConfig['homedir'];
			    $cPanel  = [
				    'is_cpanel' => false
			    ];
			    $freessl = new AcmeV2( $homedir . DS . $this->appConfig['certificate_directory'], $this->appConfig['admin_email'], $this->appConfig['is_staging'], $this->appConfig['dns_provider'], $this->appConfig['key_size'], $cPanel, $this->appConfig['server_ip'] );

			    $number_of_validated_domains_internal = 0;
			    $number_of_validated_domains = 0;
			    $error_text = "";

			    foreach ( $this->return_array_step1['domain_data'] as $domain => $value ) {
				    if ( $value['verified'] ) {
					    //Domain ownership already verified. Skip the verification process
					    //$this->logger->log("Domain (${domain}) already verified. Skip the verification process...");
					    //++ $number_of_validated_domains;
                        ++ $number_of_validated_domains_internal;
				    } else {
				        /*
				         * Run internal check here
				         */
				        if($_POST['aifs_challenge_type'] == "http-01"){
				            if($freessl->verifyDomainOwnershipHttp01Internal($domain, $value)) {
					            ++ $number_of_validated_domains_internal;
				            }
				            else{
					            //save error msg in a variable
                                if(strlen($error_text) > 1){
	                                $error_text .= "<br />";
                                }
					            $error_text .= "<span style='color: red;'>";
					            $error_text .= __("Domain: ", 'auto-install-free-ssl') . $domain . "    ";
					            $error_text .= __("Oops! We could not verify HTTP-01 challenges. Please check whether the uploaded HTTP challenge files are publicly accessible. Some hosts purposefully block BOT access to the acme-challenge folder, then please try DNS-based verification. ", 'auto-install-free-ssl');
                                $error_text .= "</span>";
					            /*$error_text .= "<span style='color: green;'>";
					            $error_text .= __("Upgrade to the PRO version for fully automatic domain verification, automated SSL installation & renewal.", 'auto-install-free-ssl');
					            $error_text .= "</span>";*/
				            }
				        }

				        if($_POST['aifs_challenge_type'] == "dns-01"){
				            if($freessl->verifyDomainOwnershipDns01Internal($domain, $value, false)) {
					            ++ $number_of_validated_domains_internal;
				            }
				            else{
					            //save error msg in a variable
					            if(strlen($error_text) > 1){
						            $error_text .= "<br />";
					            }
					            $error_text .= "<span style='color: red;'>";
					            $error_text .= __("Domain: ", 'auto-install-free-ssl') . $domain . "    ";
					            $error_text .= __("Oops! We could not verify DNS records. Please check whether you have added the DNS records perfectly. Did you add DNS records just now? Please try again after 15 minutes. ", 'auto-install-free-ssl');
					            $error_text .= "</span>";
					            /*$error_text .= "<span style='color: green;'>";
					            $error_text .= __("Upgrade to the PRO version for fully automatic domain verification, automated SSL installation & renewal.", 'auto-install-free-ssl');
					            $error_text .= "</span>";*/
				            }
				        }
				    }
			    }


                if(\count( $this->return_array_step1['response']['authorizations'] ) === $number_of_validated_domains_internal ) {
                    foreach ( $this->return_array_step1['domain_data'] as $domain => $value ) {
                        if($value['verified']){
	                        ++ $number_of_validated_domains;
                        }
                        else if ($freessl->step2VerifyDomainOwnership( $domain, $value, $_POST['aifs_challenge_type'], $this->return_array_step1 ) ) {
                            ++ $number_of_validated_domains;
                        }
                        else{
	                        //save error msg in a variable
	                        if(strlen($error_text) > 1){
		                        $error_text .= "<br />";
	                        }
	                        $error_text .= "<span style='color: red;'>";
	                        $error_text .= sprintf(__("Oops! Let's Encrypt could not validate ownership of the domain %s due to some error.", 'auto-install-free-ssl'), $domain);
	                        $error_text .= "</span>";
                        }
                    }
                }
                else{
                    /*
                     * display saved error msg in Admin alert and redirect
                    */
	                //$error_text = "<span style='color: red;'>$error_text</span>";
                    //$error_text  .= "authorizations: " .count( $this->return_array_step1['response']['authorizations'] ) ."  number_of_validated_domains_internal: ".$number_of_validated_domains_internal ." ";
	                $error_text .= "<span style='color: green;'>";
	                $error_text .= "<br />" . sprintf(__("Upgrade to the %sPRO version%s for fully automatic domain verification, automated SSL installation & renewal.", 'auto-install-free-ssl'), '<a href="'. aifssl_fs()->get_upgrade_url() .'">', '</a>');
	                $error_text .= "</span>";

	                /*echo "<pre>";
                        print_r($this->return_array_step1);
	                echo "</pre>";
	                echo $error_text;
	                return;*/

	                aifs_add_flash_notice($error_text, "error");
	                $redirect_url = admin_url('admin.php?page=aifs_generate_ssl_manually');
	                if($_POST['aifs_challenge_type'] == "dns-01"){
		                $redirect_url .= '&tab='.$_POST['aifs_challenge_type'];
	                }
	                wp_redirect($redirect_url);
	                exit;
                }


			    //Proceed to issue SSL only if total number of domains = total number of validated domains
			    if ( \count( $this->return_array_step1['response']['authorizations'] ) === $number_of_validated_domains ) {
				    // requesting certificate

				    if ( $freessl->step3GenerateSSL( $this->return_array_step1['domains_array'], false, $this->return_array_step1 ) ) {
					    //return true;
					    //update option
					    $this->return_array_step1['current_step_number'] = 3;
					    $this->return_array_step1['ssl_cert_generated']  = true;
					    update_option( 'aifs_return_array_step1_manually', $this->return_array_step1 );

					    echo $this->progress_bar(3);
					    echo "<h3 style='background: green; color: white; line-height: 1.6em; padding: 2%;'>". sprintf(__("Congratulations! SSL certificate has been issued to %s. %sPlease download it from the links given below.", 'auto-install-free-ssl'), ("<em>" . $this->return_array_step1['domains_array'][0] . "</em>"), "<br />") ."</h3>";

					    echo $home_options->single_domain_ssl_data();
				    } else {
					    echo $this->progress_bar(3);
					    //return false;
					    echo "<h3 style='color: red'>". sprintf(__("Sorry, SSL certificate was NOT issued to %s due to an error. Please check the log for details.", 'auto-install-free-ssl'), ("<em>" . $this->return_array_step1['domains_array'][0] . "</em>")) ."</h3>";
				    }

			    } else {
				    //SSL certificate can't be issued
				    echo $this->progress_bar(3);
				    $text = "Number of authorizations: " .count( $this->return_array_step1['response']['authorizations'] ) .". But number of validated domains: ".$number_of_validated_domains .". ";
				    $text .= __( "Sorry, SSL certificate can't be issued to", 'auto-install-free-ssl' ) . " " . $this->return_array_step1['domains_array'][0] . '. ' . ( \count( $this->return_array_step1['response']['authorizations'] ) - $number_of_validated_domains ) . " " . __( "domains was not validated.", 'auto-install-free-ssl' );
				    $this->logger->log_v2( 'error', $text );

				    //save error msg in a variable
				    if(strlen($error_text) > 1){
					    $error_text .= "<br />";
				    }
				    $error_text .= $text;

				    //return false;
				    $error_text .=  " <span style='font-weight: bold;'>". __( "Please check the log for details information.", 'auto-install-free-ssl' ) ."</span>";

				    aifs_add_flash_notice($error_text, "error");
				    $redirect_url = admin_url('admin.php?page=aifs_generate_ssl_manually');
				    if($_POST['aifs_challenge_type'] == "dns-01"){
					    $redirect_url .= '&tab='.$_POST['aifs_challenge_type'];
				    }
				    wp_redirect($redirect_url);
				    exit;
			    }

		    }
			/*echo "<pre>";
			print_r($this->return_array_step1);
			echo "</pre>";*/
		}

		//After click re generate SSL button
        if(isset( $_POST['aifs_proceed_regenerate'] )) {
	        if ( ! wp_verify_nonce( $_POST['aifs_regenerate_ssl'], 'aifsregeneratessl' ) ) {
		        wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
	        } else {
		        //reset option
		        unset($this->return_array_step1);
				update_option( 'aifs_return_array_step1_manually', $this->return_array_step1 );
		        wp_redirect(menu_page_url('aifs_generate_ssl_manually'), 301);
	        }
        }
	}


	/**
	 * @param int $step_number
	 *
	 * @return string
	 */
	public function progress_bar($step_number = 1){

	    $initiate = __( "Initiate", 'auto-install-free-ssl' );
		$verify = __( "Verify Domain", 'auto-install-free-ssl' );
		$download = __( "Download &amp; Install SSL", 'auto-install-free-ssl' );

	    $html = ' <div class="prcontainer">
          <ul class="progressbar">';

		if($step_number == 1) {
			$html .= '<li class="active">' . $initiate . '</li>
            <li>' . $verify . '</li>
            <li>' . $download . '</li>';
		}
		elseif($step_number == 2) {
			$html .= '<li class="done">' . $initiate . '</li>
            <li class="active">' . $verify . '</li>
            <li>' . $download . '</li>';
		}
		elseif($step_number == 3) {
			$html .= '<li class="done">' . $initiate . '</li>
            <li class="done">' . $verify . '</li>
            <li class="active">' . $download . '</li>';
		}
        elseif($step_number == 4) {
			$html .= '<li class="done">' . $initiate . '</li>
            <li class="done">' . $verify . '</li>
            <li class="done">' . $download . '</li>';
		}

		$html .= '</ul>
        </div>';

		return $html;
	}


	public function regenerate_ssl_form($button_text = null, $button_small = false){
		$html = '<form method="post" action="'.admin_url('admin.php?page=aifs_generate_ssl_manually').'">	
        			 <input type="hidden" name="aifs_proceed_regenerate" value="yes" />'.
		        wp_nonce_field('aifsregeneratessl', 'aifs_regenerate_ssl', false, false);

		$confirmation_text = __("You need to manually complete every steps again. Will you proceed?", 'auto-install-free-ssl');

		$button_text = is_null($button_text) ? __( 'Re-generate (renew) SSL', 'auto-install-free-ssl' ) : $button_text;

		if($button_small) {
			$css_class = "button button-primary";
		}
		else{
			$css_class = "button button-primary button-hero";
		}

		/*$html .=	 '<button type="submit" name="aifs_submit" class="'.$css_class.'" onclick="return confirm(\''. $confirmation_text .'\')">'. $button_text .'</button>
      			</form>';*/

		$html .=	 '<button type="submit" name="aifs_submit" class="'.$css_class.'" onclick="return aifs_confirm(\''. $confirmation_text .'\')">'. $button_text .'</button>
      			</form>';

		return $html;

	}


	public function generate_ssl_all_domains_verified_already(){
		$number_of_validated_domains = 0;
		if(isset($this->return_array_step1['domain_data']) && isset($this->return_array_step1['response']['authorizations'])) {
			foreach ( $this->return_array_step1['domain_data'] as $domain => $value ) {
				if ( $value['verified'] ) {
					++ $number_of_validated_domains;
				}
			}

			//return true only if total number of domains = total number of validated domains
			if ( \count( $this->return_array_step1['response']['authorizations'] ) === $number_of_validated_domains ) {
				return true;
			} else {
				return false;
			}
		}
		else{
		    return false;
		}

	}

}