<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package FOODIE
 * @since FOODIE 1.0.50
 */

$foodie_template_args = get_query_var( 'foodie_template_args' );
if ( is_array( $foodie_template_args ) ) {
	$foodie_columns    = empty( $foodie_template_args['columns'] ) ? 2 : max( 1, $foodie_template_args['columns'] );
	$foodie_blog_style = array( $foodie_template_args['type'], $foodie_columns );
} else {
	$foodie_blog_style = explode( '_', foodie_get_theme_option( 'blog_style' ) );
	$foodie_columns    = empty( $foodie_blog_style[1] ) ? 2 : max( 1, $foodie_blog_style[1] );
}
$foodie_blog_id       = foodie_get_custom_blog_id( join( '_', $foodie_blog_style ) );
$foodie_blog_style[0] = str_replace( 'blog-custom-', '', $foodie_blog_style[0] );
$foodie_expanded      = ! foodie_sidebar_present() && foodie_get_theme_option( 'expand_content' ) == 'expand';
$foodie_components    = ! empty( $foodie_template_args['meta_parts'] )
							? ( is_array( $foodie_template_args['meta_parts'] )
								? join( ',', $foodie_template_args['meta_parts'] )
								: $foodie_template_args['meta_parts']
								)
							: foodie_array_get_keys_by_value( foodie_get_theme_option( 'meta_parts' ) );
$foodie_post_format   = get_post_format();
$foodie_post_format   = empty( $foodie_post_format ) ? 'standard' : str_replace( 'post-format-', '', $foodie_post_format );

$foodie_blog_meta     = foodie_get_custom_layout_meta( $foodie_blog_id );
$foodie_custom_style  = ! empty( $foodie_blog_meta['scripts_required'] ) ? $foodie_blog_meta['scripts_required'] : 'none';

if ( ! empty( $foodie_template_args['slider'] ) || $foodie_columns > 1 || ! foodie_is_off( $foodie_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $foodie_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( foodie_is_off( $foodie_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $foodie_custom_style ) ) . "-1_{$foodie_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $foodie_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $foodie_columns )
					. ' post_layout_' . esc_attr( $foodie_blog_style[0] )
					. ' post_layout_' . esc_attr( $foodie_blog_style[0] ) . '_' . esc_attr( $foodie_columns )
					. ( ! foodie_is_off( $foodie_custom_style )
						? ' post_layout_' . esc_attr( $foodie_custom_style )
							. ' post_layout_' . esc_attr( $foodie_custom_style ) . '_' . esc_attr( $foodie_columns )
						: ''
						)
		);
	foodie_add_blog_animation( $foodie_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'foodie_action_show_layout', $foodie_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $foodie_template_args['slider'] ) || $foodie_columns > 1 || ! foodie_is_off( $foodie_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
