<?php
$foodie_woocommerce_sc = foodie_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $foodie_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$foodie_scheme = foodie_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $foodie_scheme ) && ! foodie_is_inherit( $foodie_scheme ) ) {
			echo ' scheme_' . esc_attr( $foodie_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( foodie_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( foodie_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$foodie_css      = '';
			$foodie_bg_image = foodie_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $foodie_bg_image ) ) {
				$foodie_css .= 'background-image: url(' . esc_url( foodie_get_attachment_url( $foodie_bg_image ) ) . ');';
			}
			if ( ! empty( $foodie_css ) ) {
				echo ' style="' . esc_attr( $foodie_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$foodie_anchor_icon = foodie_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$foodie_anchor_text = foodie_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $foodie_anchor_icon ) || ! empty( $foodie_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $foodie_anchor_icon ) ? ' icon="' . esc_attr( $foodie_anchor_icon ) . '"' : '' )
											. ( ! empty( $foodie_anchor_text ) ? ' title="' . esc_attr( $foodie_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( foodie_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' foodie-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$foodie_css      = '';
				$foodie_bg_mask  = foodie_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$foodie_bg_color_type = foodie_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $foodie_bg_color_type ) {
					$foodie_bg_color = foodie_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $foodie_bg_color_type ) {
					$foodie_bg_color = foodie_get_scheme_color( 'bg_color', $foodie_scheme );
				} else {
					$foodie_bg_color = '';
				}
				if ( ! empty( $foodie_bg_color ) && $foodie_bg_mask > 0 ) {
					$foodie_css .= 'background-color: ' . esc_attr(
						1 == $foodie_bg_mask ? $foodie_bg_color : foodie_hex2rgba( $foodie_bg_color, $foodie_bg_mask )
					) . ';';
				}
				if ( ! empty( $foodie_css ) ) {
					echo ' style="' . esc_attr( $foodie_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$foodie_caption     = foodie_get_theme_option( 'front_page_woocommerce_caption' );
				$foodie_description = foodie_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $foodie_caption ) || ! empty( $foodie_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $foodie_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $foodie_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $foodie_caption, 'foodie_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $foodie_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $foodie_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $foodie_description ), 'foodie_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $foodie_woocommerce_sc ) {
						$foodie_woocommerce_sc_ids      = foodie_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$foodie_woocommerce_sc_per_page = count( explode( ',', $foodie_woocommerce_sc_ids ) );
					} else {
						$foodie_woocommerce_sc_per_page = max( 1, (int) foodie_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$foodie_woocommerce_sc_columns = max( 1, min( $foodie_woocommerce_sc_per_page, (int) foodie_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$foodie_woocommerce_sc}"
										. ( 'products' == $foodie_woocommerce_sc
												? ' ids="' . esc_attr( $foodie_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $foodie_woocommerce_sc
												? ' category="' . esc_attr( foodie_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $foodie_woocommerce_sc
												? ' orderby="' . esc_attr( foodie_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( foodie_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $foodie_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $foodie_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
