<?php
$foodie_slider_sc = foodie_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $foodie_slider_sc ) && strpos( $foodie_slider_sc, '[' ) !== false && strpos( $foodie_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( foodie_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$foodie_anchor_icon = foodie_get_theme_option( 'front_page_title_anchor_icon' );
		$foodie_anchor_text = foodie_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $foodie_anchor_icon ) || ! empty( $foodie_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $foodie_anchor_icon ) ? ' icon="' . esc_attr( $foodie_anchor_icon ) . '"' : '' )
									. ( ! empty( $foodie_anchor_text ) ? ' title="' . esc_attr( $foodie_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $foodie_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$foodie_scheme = foodie_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $foodie_scheme ) && ! foodie_is_inherit( $foodie_scheme ) ) {
			echo ' scheme_' . esc_attr( $foodie_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( foodie_get_theme_option( 'front_page_title_paddings' ) );
		if ( foodie_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$foodie_css      = '';
		$foodie_bg_image = foodie_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $foodie_bg_image ) ) {
			$foodie_css .= 'background-image: url(' . esc_url( foodie_get_attachment_url( $foodie_bg_image ) ) . ');';
		}
		if ( ! empty( $foodie_css ) ) {
			echo ' style="' . esc_attr( $foodie_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$foodie_anchor_icon = foodie_get_theme_option( 'front_page_title_anchor_icon' );
		$foodie_anchor_text = foodie_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $foodie_anchor_icon ) || ! empty( $foodie_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $foodie_anchor_icon ) ? ' icon="' . esc_attr( $foodie_anchor_icon ) . '"' : '' )
									. ( ! empty( $foodie_anchor_text ) ? ' title="' . esc_attr( $foodie_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( foodie_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' foodie-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$foodie_css      = '';
			$foodie_bg_mask  = foodie_get_theme_option( 'front_page_title_bg_mask' );
			$foodie_bg_color_type = foodie_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $foodie_bg_color_type ) {
				$foodie_bg_color = foodie_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $foodie_bg_color_type ) {
				$foodie_bg_color = foodie_get_scheme_color( 'bg_color', $foodie_scheme );
			} else {
				$foodie_bg_color = '';
			}
			if ( ! empty( $foodie_bg_color ) && $foodie_bg_mask > 0 ) {
				$foodie_css .= 'background-color: ' . esc_attr(
					1 == $foodie_bg_mask ? $foodie_bg_color : foodie_hex2rgba( $foodie_bg_color, $foodie_bg_mask )
				) . ';';
			}
			if ( ! empty( $foodie_css ) ) {
				echo ' style="' . esc_attr( $foodie_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$foodie_caption = foodie_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $foodie_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $foodie_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $foodie_caption, 'foodie_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$foodie_description = foodie_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $foodie_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $foodie_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $foodie_description ), 'foodie_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( foodie_get_theme_option( 'front_page_title_button1_link' ) != '' || foodie_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						foodie_show_layout( foodie_customizer_partial_refresh_front_page_title_button1_link() );
						foodie_show_layout( foodie_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
