<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

							do_action( 'foodie_action_page_content_end_text' );
							
							// Widgets area below the content
							foodie_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'foodie_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'foodie_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'foodie_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'foodie_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$foodie_body_style = foodie_get_theme_option( 'body_style' );
					$foodie_widgets_name = foodie_get_theme_option( 'widgets_below_page' );
					$foodie_show_widgets = ! foodie_is_off( $foodie_widgets_name ) && is_active_sidebar( $foodie_widgets_name );
					$foodie_show_related = foodie_is_single() && foodie_get_theme_option( 'related_position' ) == 'below_page';
					if ( $foodie_show_widgets || $foodie_show_related ) {
						if ( 'fullscreen' != $foodie_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $foodie_show_related ) {
							do_action( 'foodie_action_related_posts' );
						}

						// Widgets area below page content
						if ( $foodie_show_widgets ) {
							foodie_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $foodie_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'foodie_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'foodie_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! foodie_is_singular( 'post' ) && ! foodie_is_singular( 'attachment' ) ) || ! in_array ( foodie_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="foodie_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'foodie_action_before_footer' );

				// Footer
				$foodie_footer_type = foodie_get_theme_option( 'footer_type' );
				if ( 'custom' == $foodie_footer_type && ! foodie_is_layouts_available() ) {
					$foodie_footer_type = 'default';
				}
				get_template_part( apply_filters( 'foodie_filter_get_template_part', "templates/footer-" . sanitize_file_name( $foodie_footer_type ) ) );

				do_action( 'foodie_action_after_footer' );

			}
			?>

			<?php do_action( 'foodie_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'foodie_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'foodie_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>