const track = document.querySelector(".custom-carousel-track");
const items = Array.from(track.children);
const prevButton = document.querySelector(".custom-control.custom-prev");
const nextButton = document.querySelector(".custom-control.custom-next");

let currentIndex = 2; // Center item index initially (3rd image)
let autoSlideInterval = 5000; // 5 seconds
let autoSlideTimer;

// Function to update item classes
function updateItems() {
  items.forEach((item, index) => {
    item.classList.remove("custom-active");
    if (index === currentIndex) {
      item.classList.add("custom-active");
    }
  });
}

// Function to move the carousel
function moveCarousel() {
  const offset = -((currentIndex - 1) * (100 / 3)); // Center the active item
  track.style.transform = `translateX(${offset}%)`;
}

// Function to auto-slide the carousel
function autoSlide() {
  autoSlideTimer = setInterval(() => {
    currentIndex = (currentIndex + 1) % items.length; // Loop back to start
    updateItems();
    moveCarousel();
  }, autoSlideInterval);
}

// Function to reset the auto-slide timer
function resetAutoSlide() {
  clearInterval(autoSlideTimer);
  autoSlide();
}

// Event listeners for buttons
prevButton.addEventListener("click", () => {
  currentIndex = (currentIndex - 1 + items.length) % items.length; // Loop back to end
  updateItems();
  moveCarousel();
  resetAutoSlide();
});

nextButton.addEventListener("click", () => {
  currentIndex = (currentIndex + 1) % items.length; // Loop back to start
  updateItems();
  moveCarousel();
  resetAutoSlide();
});

// Initialize
updateItems();
moveCarousel();
autoSlide(); // Start auto-slide




document.addEventListener("DOMContentLoaded", () => {
  const scrollToTopBtn = document.getElementById("scrollToTopBtn");

  // Function to show/hide the button based on scroll position
  const toggleScrollToTopButton = () => {
      const scrollPosition = window.scrollY + window.innerHeight; // Current scroll + viewport height
      const documentHeight = document.documentElement.scrollHeight; // Total document height

      if (scrollPosition >= documentHeight - 50) { // Show near the bottom
          scrollToTopBtn.classList.add("show");
      } else {
          scrollToTopBtn.classList.remove("show");
      }
  };

  // Scroll to the top when the button is clicked
  scrollToTopBtn.addEventListener("click", () => {
      window.scrollTo({
          top: 0,
          behavior: "smooth"
      });
  });

  // Listen for scroll events
  window.addEventListener("scroll", toggleScrollToTopButton);
});


 // JavaScript to control popup behavior
 const popupOverlay = document.getElementById('popupOverlay');
 const closePopup = document.getElementById('closePopup');

 // Automatically show the popup on page load
 window.addEventListener('load', () => {
   popupOverlay.classList.remove('hidden');
 });

 // Close the popup
 closePopup.addEventListener('click', () => {
   popupOverlay.classList.add('hidden');
 });

 // Close when clicking outside the popup
 popupOverlay.addEventListener('click', (event) => {
   if (event.target === popupOverlay) {
     popupOverlay.classList.add('hidden');
   }
 });



 // Dynamically inject SVG icons and click handling

document.addEventListener("DOMContentLoaded", function () {
  // Add SVG dynamically
  const svgIcons = {
      date: `<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 5.5L6.5 5.5V5C6.5 4.17157 7.17157 3.5 8 3.5C8.82843 3.5 9.5 4.17157 9.5 5V5.5L12.5 5.5V5C12.5 4.17157 13.1716 3.5 14 3.5C14.8284 3.5 15.5 4.17157 15.5 5V5.5H16.5C17.8807 5.5 19 6.61929 19 8V10.6429C19 10.919 18.7761 11.1429 18.5 11.1429C18.2239 11.1429 18 10.919 18 10.6429V10.5H4L4 17C4 17.8284 4.67157 18.5 5.5 18.5L9.5 18.5C9.77614 18.5 10 18.7239 10 19C10 19.2761 9.77614 19.5 9.5 19.5H5.5C4.11929 19.5 3 18.3807 3 17V8C3 6.61929 4.11929 5.5 5.5 5.5ZM7.5 5V7C7.5 7.27614 7.72386 7.5 8 7.5C8.27614 7.5 8.5 7.27614 8.5 7V5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5ZM14.5 5C14.5 4.72386 14.2761 4.5 14 4.5C13.7239 4.5 13.5 4.72386 13.5 5V7C13.5 7.27614 13.7239 7.5 14 7.5C14.2761 7.5 14.5 7.27614 14.5 7V5ZM12.5 6.5V7C12.5 7.82843 13.1716 8.5 14 8.5C14.8284 8.5 15.5 7.82843 15.5 7V6.5L16.5 6.5C17.3284 6.5 18 7.17157 18 8V9.5H4L4 8C4 7.17157 4.67157 6.5 5.5 6.5H6.5V7C6.5 7.82843 7.17157 8.5 8 8.5C8.82843 8.5 9.5 7.82843 9.5 7V6.5L12.5 6.5Z" fill="#45474D"></path></svg>`,
      location: `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="css-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 10.0714C5.5 6.2881 8.96304 4 12 4C15.037 4 18.5 6.2881 18.5 10.0714C18.5 12.4463 17.3299 14.5887 15.8656 16.3303C14.4439 18.0211 12.8224 19.2405 12 19.8053C11.1776 19.2405 9.55612 18.0211 8.13442 16.3303C6.67006 14.5887 5.5 12.4463 5.5 10.0714ZM4.5 10.0714C4.5 5.57143 8.59091 3 12 3C15.4091 3 19.5 5.57143 19.5 10.0714C19.5 15.4847 14.1819 19.5305 12.5021 20.6734C12.1968 20.8812 11.8032 20.8812 11.4979 20.6734C9.81808 19.5305 4.5 15.4847 4.5 10.0714ZM10 10.5C10 9.39543 10.8954 8.5 12 8.5C13.1046 8.5 14 9.39543 14 10.5C14 11.6046 13.1046 12.5 12 12.5C10.8954 12.5 10 11.6046 10 10.5ZM12 7.5C10.3431 7.5 9 8.84315 9 10.5C9 12.1569 10.3431 13.5 12 13.5C13.6569 13.5 15 12.1569 15 10.5C15 8.84315 13.6569 7.5 12 7.5Z" fill="#45474D"></path></svg>`,
  };

  document.querySelectorAll(".item").forEach((item) => {
      // Set event details
      const dateElement = item.querySelector(".event-date");
      const locationElement = item.querySelector(".event-location");

      dateElement.innerHTML = svgIcons.date + " September 15th, 2024 | 4:30 PM";
      locationElement.innerHTML = svgIcons.location + " Location Not Disclosed";

      // Make entire item clickable
      item.addEventListener("click", function () {
          const link = item.getAttribute("data-link");
          if (link) {
              window.location.href = link;
          }
      });
  });
});

document.addEventListener("DOMContentLoaded", () => {
  const filterButtons = document.querySelectorAll(".filter-btn");
  const galleryItems = document.querySelectorAll(".gallery-item");

  filterButtons.forEach(button => {
    button.addEventListener("click", () => {
      // Remove active class from all buttons
      filterButtons.forEach(btn => btn.classList.remove("active"));
      // Add active class to the clicked button
      button.classList.add("active");

      const category = button.getAttribute("data-category");

      // Show/hide gallery items
      galleryItems.forEach(item => {
        if (category === "all" || item.classList.contains(category)) {
          item.style.display = "block";
        } else {
          item.style.display = "none";
        }
      });
    });
  });
});


document.addEventListener("DOMContentLoaded", () => {
  const slides = document.querySelectorAll(".reel-slide");
  const prevButton = document.getElementById("prev-slide");
  const nextButton = document.getElementById("next-slide");
  let currentSlide = 0;

  const showSlide = (index) => {
    slides.forEach((slide, i) => {
      slide.style.transform = `translateX(${(i - index) * 100}%)`;
    });
  };

  prevButton.addEventListener("click", () => {
    currentSlide = (currentSlide === 0) ? slides.length - 1 : currentSlide - 1;
    showSlide(currentSlide);
  });

  nextButton.addEventListener("click", () => {
    currentSlide = (currentSlide === slides.length - 1) ? 0 : currentSlide + 1;
    showSlide(currentSlide);
  });

  // Initialize slider
  showSlide(currentSlide);
});
