<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'ManufakturSolutionsMembershipTwitterApi' ) ) {
	/**
	 * Class ManufakturSolutionsMembershipTwitterApi
	 */
	class ManufakturSolutionsMembershipTwitterApi {
		/**
		 * @var $instance ManufakturSolutionsMembershipTwitterApi class object
		 */
		private static $instance;

		/**
		 * Key that was provided by Twitter when application was created
		 * @var string
		 */
		private $consumerKey;

		/**
		 * Secret code for application that was generated by Twitter
		 * @var string
		 */
		private $consumerSecret;

		/**
		 *
		 * URL where user will be redirected once he authorizes access to our application
		 * @var string
		 */
		private $redirectURI;

		/**
		 * URL from which we can obtain request token that will be used to get access token
		 * @var string
		 */
		private $requestTokenURL;

		/**
		 * URL where user can authorize our application
		 * @var string
		 */
		private $authorizeURL;

		/**
		 * URL from which we can obtain access token
		 * @var
		 */
		private $accessTokenUrl;

		/**
		 * URL from which we can obtain user email for login
		 * @var
		 */
		private $getEmailUrl;

		/**
		 * Signature hashin method that is used by Twitter OAuth
		 * @var string
		 */
		private $signatureMethod;

		/**
		 * OAuth version that is used by Twitter
		 * @var string
		 */
		private $oauthVersion;

		/**
		 * Private constructor because of singletone pattern. It sets all necessary properties
		 */
		public function __construct() {
			$this->consumerKey     = 'r0itIfcQ0pWe6LeJj601jDrrb';
			$this->consumerSecret  = 'BZpFVbBskD9NvtY3A679IGE2PV4E2H6bNx4RE4fvYMYl7zD5A1';
			$this->redirectURI     = 'https://qodeinteractive.com/twitter-app/twitter-redirect.php';
			$this->signatureMethod = 'HMAC-SHA1';
			$this->oauthVersion    = '1.0';
			$this->requestTokenURL = 'https://api.twitter.com/oauth/request_token';
			$this->authorizeURL    = 'https://api.twitter.com/oauth/authorize';
			$this->accessTokenUrl  = 'https://api.twitter.com/oauth/access_token';
			$this->getEmailUrl     = 'https://api.twitter.com/1.1/account/verify_credentials.json';
		}

		/**
		 * @return ManufakturSolutionsMembershipTwitterApi
		 */
		public static function getInstance() {
			if ( self::$instance === null ) {
				return new self();
			}

			return self::$instance;
		}

		/**
		 * Generates signature base that will be used to generate request signature.
		 * Signature is used by Twitter to check authorization of request
		 *
		 * @param string $requestUrl URL that we are requesting
		 * @param string $method HTTP method. Can be GET or POST
		 * @param array $params array of parameters from which to generate signature base
		 *
		 * @return string generated signature base
		 */
		private function generateSignatureBase( $requestUrl, $method, $params ) {
			$encodedParams       = array();
			$encodedParamsString = '';
			$method              = strtoupper( $method );

			$base = $method . '&' . rawurlencode( $requestUrl ) . '&';

			if ( is_array( $params ) && count( $params ) ) {
				foreach ( $params as $key => $value ) {
					$encodedParams[ rawurlencode( $key ) ] = rawurlencode( $value );
				}

				ksort( $encodedParams );

				foreach ( $encodedParams as $key => $value ) {
					$encodedParamsString .= $key . '=' . $value . '&';
				}

				$encodedParamsString = rtrim( $encodedParamsString, '&' );
			}

			$base .= rawurlencode( $encodedParamsString );

			return $base;
		}

		/**
		 * Generates signature. Uses consumer secret as hashing key and uses sha1 as hashing algorithm
		 *
		 * @param string $requestUrl URL that we are requesting
		 * @param string $method HTTP method. Can be GET of POST
		 * @param array $params array of parameters from which to generate signature
		 * @param string $tokenSecret
		 *
		 * @return string generated signature
		 *
		 * @see ManufakturSolutionsMembershipTwitterApi::generateSignatureBase()
		 */
		private function generateSignature( $requestUrl, $method, $params, $tokenSecret = '' ) {
			$base = $this->generateSignatureBase( $requestUrl, $method, $params );

			$signatureKey = rawurlencode( $this->consumerSecret ) . '&';

			if ( $tokenSecret !== '' ) {
				$signatureKey .= rawurlencode( $tokenSecret );
			}

			return base64_encode( hash_hmac( 'sha1', $base, $signatureKey, true ) );
		}

		/**
		 * Generates OAuth authorization header base on provided request params
		 *
		 * @param array $requestParams
		 *
		 * @return string
		 */
		private function generateOAuthHeader( $requestParams ) {
			$header = array();
			if ( is_array( $requestParams ) && count( $requestParams ) ) {
				foreach ( $requestParams as $key => $value ) {
					$header[] = rawurlencode( $key ) . '="' . rawurlencode( $value ) . '"';
				}
			}

			return 'OAuth ' . implode( ', ', $header );
		}

		/**
		 * Generates hashed random number sequence that is used on each request
		 * @return string
		 */
		private function generateNonce() {
			return md5( mt_rand() );
		}

		/**
		 * Returns current UNIX time
		 * @return int
		 */
		private function generateTimestamp() {
			return time();
		}

		/**
		 * Sends request to Twitter in order to obtain request token.
		 * When Twitter returns request token it is saved in database along with request token secret.
		 * It builds response object that is returned to client and which has status, message and redirectURL (authorize URL) properties
		 */
		public function obtainRequestToken() {
			$responseObj    = new stdClass();
			$currentPageUrl = ! empty( $_POST['url'] ) ? $_POST['url'] : $this->buildCurrentPageURI();

			$requestParams = array(
				'oauth_callback'         => $this->buildRedirectURL( $currentPageUrl ),
				'oauth_consumer_key'     => $this->consumerKey,
				'oauth_nonce'            => $this->generateNonce(),
				'oauth_signature_method' => $this->signatureMethod,
				'oauth_timestamp'        => $this->generateTimestamp(),
				'oauth_version'          => $this->oauthVersion
			);

			$requestParams['oauth_signature'] = $this->generateSignature( $this->requestTokenURL, 'POST', $requestParams );
			$OAuthHeader                      = $this->generateOAuthHeader( $requestParams );
			$requestTokenData                 = array(
				'method'   => 'POST',
				'blocking' => true,
				'headers'  => array(
					'Authorization' => $OAuthHeader,
					'Content-Type'  => 'application/x-www-form-urlencoded;charset=UTF-8'
				)
			);

			$response = wp_remote_post( $this->requestTokenURL, $requestTokenData );

			if ( is_wp_error( $response ) ) {
				$responseObj->status  = false;
				$responseObj->message = esc_html__( 'Internal WP error', 'manufaktursolutions-membership' );
			} else {
				$responseBody = wp_remote_retrieve_body( $response );

				if ( ! empty( $responseBody ) ) {
					parse_str( $responseBody, $responseParsed );

					if ( ( is_array( $responseParsed ) && count( $responseParsed ) ) && ! empty( $responseParsed['oauth_token'] ) && ! empty( $responseParsed['oauth_token_secret'] ) ) {

						$responseObj->oauth_token        = $responseParsed['oauth_token'];
						$responseObj->oauth_token_secret = $responseParsed['oauth_token_secret'];
						$responseObj->redirectUrl        = $this->buildAuthorizeURL( $responseParsed['oauth_token'] );
						if ( empty( $responseObj->redirectUrl ) ) {
							$responseObj->oauth_callback_confirmed = false;
							$responseObj->message                  = esc_html__( 'Redirect URL could not be generated', 'manufaktursolutions-membership' );
						} else {
							$responseObj->oauth_callback_confirmed = true;
						}
					} else {
						$responseObj->oauth_callback_confirmed = false;
						$responseObj->message                  = esc_html__( 'Couldn\'t connect with Twitter API', 'manufaktursolutions-membership' );
					}
				}
			}

			return $responseObj;
		}

		/**
		 * @return stdClass
		 */
		public function obtainAccessToken( $oauth_token, $oauth_verifier ) {
			$responseObj       = new stdClass();
			$authorizeVerifier = $oauth_verifier;
			$authorizeToken    = $oauth_token;

			if ( ! empty( $authorizeVerifier ) && ! empty( $authorizeToken ) ) {
				$requestParams = array(
					'oauth_consumer_key'     => $this->consumerKey,
					'oauth_nonce'            => $this->generateNonce(),
					'oauth_signature_method' => $this->signatureMethod,
					'oauth_timestamp'        => $this->generateTimestamp(),
					'oauth_version'          => $this->oauthVersion
				);

				$requestParams['oauth_signature'] = $this->generateSignature( $this->accessTokenUrl, 'POST', $requestParams );

				$requestData = array(
					'method'  => 'POST',
					'headers' => array(
						'Authorization' => $this->generateOAuthHeader( $requestParams ),
						'Content-Type'  => 'application/x-www-form-urlencoded;charset=UTF-8'
					),
					'body'    => array(
						'oauth_verifier' => rawurlencode( $authorizeVerifier ),
						'oauth_token'    => rawurlencode( $authorizeToken )
					)
				);

				$response = wp_remote_post( $this->accessTokenUrl, $requestData );

				if ( is_wp_error( $response ) ) {
					$responseObj->status  = false;
					$responseObj->message = esc_html__( 'Internal WP error', 'manufaktursolutions-membership' );
				} else {
					$responseBody = wp_remote_retrieve_body( $response );
					parse_str( $responseBody, $responseParsed );
					if ( is_array( $responseParsed ) && count( $responseParsed ) && ! empty( $responseParsed['oauth_token'] ) && ! empty( $responseParsed['oauth_token_secret'] ) && ! empty( $responseParsed['user_id'] ) && ! empty( $responseParsed['screen_name'] ) ) {
						$responseObj->status             = true;
						$responseObj->oauth_token        = $responseParsed['oauth_token'];
						$responseObj->oauth_token_secret = $responseParsed['oauth_token_secret'];
					} else {
						$responseObj->status = false;
					}
				}
			} else {
				$responseObj->status = false;
			}

			return $responseObj;
		}

		public function getUserEmail( $access_token, $access_token_secret ) {
			$responseObj = new stdClass();

			$requestParams = array(
				'oauth_consumer_key'     => $this->consumerKey,
				'oauth_nonce'            => $this->generateNonce(),
				'oauth_signature_method' => $this->signatureMethod,
				'oauth_timestamp'        => $this->generateTimestamp(),
				'oauth_version'          => $this->oauthVersion,
				'oauth_token'            => $access_token,
				'include_email'          => "true",
			);

			$requestParams['oauth_signature'] = $this->generateSignature( $this->getEmailUrl, 'GET', $requestParams, $access_token_secret );

			unset( $requestParams['include_email'] );

			$requestTokenData = array(
				'headers' => array(
					'Authorization' => $this->generateOAuthHeader( $requestParams ),
					'Content-Type'  => 'application/x-www-form-urlencoded;charset=UTF-8'
				)
			);

			$response = wp_remote_get( $this->getEmailUrl . '?include_email=true', $requestTokenData );

			if ( is_wp_error( $response ) ) {
				$responseObj->status = false;
			} else {
				if ( isset( $response['response']['code'] ) && $response['response']['code'] == 200 ) {
					$responseObj->status = true;
					$responseObj->data   = json_decode( wp_remote_retrieve_body( $response ), true );
				} else {
					$responseObj->status = false;
				}
			}

			return $responseObj;
		}

		/**
		 * Generates URL where user will authorize our application. Appends request token parameter to Twitter URL
		 * @return bool|string
		 */
		private function buildAuthorizeURL( $request_token ) {
			if ( ! empty( $request_token ) ) {
				return $this->authorizeURL . '?oauth_token=' . $request_token;
			}

			return false;
		}

		/**
		 * Generates URL where user will be redirected once he authorizes our application
		 *
		 * @param string $redirectUrl
		 *
		 * @return string
		 */
		private function buildRedirectURL( $redirectUrl ) {
			return $this->redirectURI . '?redirect_url=' . $redirectUrl;
		}

		/**
		 * Returns current page URL
		 * @return string
		 */
		public function buildCurrentPageURI() {
			$protocol = is_ssl() ? 'https' : 'http';
			$site     = $_SERVER['SERVER_NAME'];
			$slug     = $_SERVER['REQUEST_URI'];

			//		return $protocol . '://' . $site . $slug;
			return manufaktursolutions_membership_get_membership_redirect_url();
		}
	}
}
