<?php

if ( ! function_exists( 'manufaktursolutions_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function manufaktursolutions_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'manufaktursolutions_filter_mobile_header_template', manufaktursolutions_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'manufaktursolutions_action_page_header_template', 'manufaktursolutions_load_page_mobile_header' );
}

if ( ! function_exists( 'manufaktursolutions_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function manufaktursolutions_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'manufaktursolutions_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'manufaktursolutions' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'manufaktursolutions_action_after_include_modules', 'manufaktursolutions_register_mobile_navigation_menus' );
}
