<?php

if ( ! function_exists( 'manufaktursolutions_core_add_banner_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_banner_shortcode( $shortcodes ) {
		$shortcodes[] = 'ManufakturSolutionsCore_Banner_Shortcode';

		return $shortcodes;
	}

	add_filter( 'manufaktursolutions_core_filter_register_shortcodes', 'manufaktursolutions_core_add_banner_shortcode' );
}

if ( class_exists( 'ManufakturSolutionsCore_Shortcode' ) ) {
	class ManufakturSolutionsCore_Banner_Shortcode extends ManufakturSolutionsCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'manufaktursolutions_core_filter_banner_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'manufaktursolutions_core_filter_banner_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( MANUFAKTURSOLUTIONS_CORE_SHORTCODES_URL_PATH . '/banner' );
			$this->set_base( 'manufaktursolutions_core_banner' );
			$this->set_name( esc_html__( 'Banner', 'manufaktursolutions-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds banner element', 'manufaktursolutions-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'manufaktursolutions-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'manufaktursolutions-core' ),
						'light' => esc_html__( 'Light', 'manufaktursolutions-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_top_border',
					'title'         => esc_html__( 'Enable Top Border', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'no_yes' ),
					'default_value' => 'no',
				)
			);

			$options_map = manufaktursolutions_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'manufaktursolutions-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'image',
					'title'      => esc_html__( 'Image', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link_url',
					'title'      => esc_html__( 'Link', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'link_target',
					'title'         => esc_html__( 'Link Target', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'manufaktursolutions-core' ),
					'default_value' => esc_html__( 'Title Text', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h4',
					'group'         => esc_html__( 'Title Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'manufaktursolutions-core' ),
					'group'      => esc_html__( 'Title Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'manufaktursolutions-core' ),
					'group'      => esc_html__( 'Title Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'line_break_positions',
					'title'       => esc_html__( 'Positions of Line Break', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'manufaktursolutions-core' ),
					'group'       => esc_html__( 'Title Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_line_break',
					'title'         => esc_html__( 'Disable Line Break On Mobile', 'manufaktursolutions-core' ),
					'group'         => esc_html__( 'Title Style', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'no_yes' ),
					'default_value' => 'no',
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'title_highlight_words',
					'title'       => esc_html__( 'Words with Highlights Color', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Enter the positions of the words you would like to display in a "highlights" color. Separate the positions with commas (e.g. if you would like the first, second, and third word to have a highlights color, you would enter "1,2,3")', 'manufaktursolutions-core' ),
					'group'       => esc_html__( 'Title Style', 'manufaktursolutions-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle',
					'title'      => esc_html__( 'Subtitle', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'subtitle_tag',
					'title'         => esc_html__( 'Subtitle Tag', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Subtitle Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'manufaktursolutions-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle_margin_top',
					'title'      => esc_html__( 'Subtitle Margin Top', 'manufaktursolutions-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'text_field',
					'title'      => esc_html__( 'Text', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_tag',
					'title'         => esc_html__( 'Text Tag', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'p',
					'group'         => esc_html__( 'Text Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'manufaktursolutions-core' ),
					'group'      => esc_html__( 'Text Style', 'manufaktursolutions-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'manufaktursolutions-core' ),
					'group'      => esc_html__( 'Text Style', 'manufaktursolutions-core' ),
				)
			);
			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'manufaktursolutions_core_button',
					'exclude'           => array( 'custom_class', 'link', 'target' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'manufaktursolutions-core' ),
						'dependency'   => array(
							'show' => array(
								'layout' => array(
									'values'        => 'link-button',
									'default_value' => '',
								),
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'appear',
					'title'      => esc_html__( 'Appear Animation', 'manufaktursolutions-core' ),
					'options'    => manufaktursolutions_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']  = $this->get_holder_classes( $atts );
			$atts['title']           = $this->get_modified_title( $atts );
			$atts['title_styles']    = $this->get_title_styles( $atts );
			$atts['subtitle_styles'] = $this->get_subtitle_styles( $atts );
			$atts['text_styles']     = $this->get_text_styles( $atts );
			$atts['button_params']   = $this->generate_button_params( $atts );

			return manufaktursolutions_core_get_template_part( 'shortcodes/banner', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-banner';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = isset( $atts['skin'] ) && ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';
			$holder_classes[] = 'yes' === $atts['enable_top_border'] ? 'qodef-enable-top-border--yes' : 'qodef-enable-top-border--no';
			$holder_classes[] = 'yes' === $atts['disable_line_break'] ? 'qodef-disable-line-break--yes' : 'qodef-disable-line-break--no';
			$holder_classes[] = ! empty( $atts['appear'] ) && ( 'yes' === $atts['appear'] ) ? 'qodef-has-appear' : '';

			return implode( ' ', $holder_classes );
		}

		private function get_modified_title( $atts ) {
			$title                 = $atts['title'];
			$title_highlight_words = str_replace( ' ', '', $atts['title_highlight_words'] );


			if ( ! empty( $title ) ) {
				$split_title          = explode( ' ', $title );
				$line_break_positions = explode( ',', str_replace( ' ', '', $atts['line_break_positions'] ) );
				$highlights_words     = explode( ',', $title_highlight_words );

				if ( ! empty( $atts['line_break_positions'] ) ) {
					foreach ( $line_break_positions as $position ) {
						$position = intval( $position );
						if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
							$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
						}
					}
				}
				if ( ! empty( $title_highlight_words ) ) {
					foreach ( $highlights_words as $value ) {
						$value = intval( $value );
						if ( ! empty( $split_title[ $value - 1 ] ) ) {
							$split_title[ $value - 1 ] = '<span class="qodef-highlight-title">' . $split_title[ $value - 1 ] . '</span>';
						}
					}
				}


				$title = implode( ' ', $split_title );
			}

			return $title;
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['title_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

		private function get_subtitle_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['subtitle_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['subtitle_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['subtitle_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['subtitle_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['subtitle_color'] ) ) {
				$styles[] = 'color: ' . $atts['subtitle_color'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}

		private function generate_button_params( $atts ) {
			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'manufaktursolutions_core_button',
					'exclude'        => array( 'custom_class', 'link', 'target' ),
					'atts'           => $atts,
				)
			);

			$params['link']   = ! empty( $atts['link_url'] ) ? $atts['link_url'] : '';
			$params['target'] = ! empty( $atts['link_target'] ) ? $atts['link_target'] : '';

			return $params;
		}
	}
}
