(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.manufaktursolutions_core_banner = {};

	$( document ).ready(
		function () {
			qodefBanner.init();
		}
	);

	var qodefBanner = {
		init: function () {
			this.holder = $( '.qodef-banner.qodef-layout--link-button' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefBanner.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {

			qodef.qodefWaitForImages.check(
				$currentItem,
				function () {
					qodefCore.qodefIsInViewport.check(
						$currentItem,
						function () {
							$currentItem.addClass( 'qodef--appeared' );
						}
					);
				}
			);

			var $button = $currentItem.find( '.qodef-button' );

			$button.on(
				'mouseenter',
				function () {
					$currentItem.addClass( 'qodef--hover' );
				}
			).on(
				'mouseleave',
				function () {
					$currentItem.removeClass( 'qodef--hover' );
				}
			);
		},
	};

	qodefCore.shortcodes.manufaktursolutions_core_banner.qodefBanner = qodefBanner;

})( jQuery );
