<?php
$post_id = get_the_ID();
$is_enabled = manufaktursolutions_core_get_post_value_through_levels('qodef_blog_single_enable_related_posts');
$related_posts = manufaktursolutions_core_get_custom_post_type_related_posts($post_id, manufaktursolutions_core_get_blog_single_post_taxonomies($post_id));

if ('yes' === $is_enabled && !empty($related_posts) && class_exists('ManufakturSolutionsCore_Blog_List_Shortcode')) { ?>
    <div id="qodef-related-posts">
        <?php echo '<h3>' . esc_html__('Related Posts', 'manufaktursolutions-core') . '</h3>'; ?>
        <?php
        $params = apply_filters(
            'manufaktursolutions_core_filter_blog_single_related_posts_params',
            array(
                'custom_class' => 'qodef--no-bottom-space',
                'columns' => '3',
                'posts_per_page' => 3,
                'additional_params' => 'id',
                'post_ids' => $related_posts['items'],
                'title_tag' => 'h5',
                'media_only_image' => 'yes',
                'images_proportion' => 'custom',
                'custom_image_width' => '632px',
                'space' => 'small',
                'custom_image_height' => '764px',
                'layout' => 'standard',
                'excerpt' => 'no',
                'standard_textual_button' => 'no',
            )
        );

        echo ManufakturSolutionsCore_Blog_List_Shortcode::call_shortcode($params);
        ?>
    </div>
<?php } ?>
