(function ( $ ) {
	'use strict';

	var shortcode = 'manufaktursolutions_core_blog_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

	$( document ).on(
		'manufaktursolutions_trigger_get_new_posts',
		function () {
			qodefBlogList.init();
		}
	);

	$( document ).ready(
		function () {
			qodefBlogList.init();
		}
	);

	var qodefBlogList = {
		init: function () {
			this.holder = $( '.qodef-blog' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefBlogList.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentList ) {
			var $items = $currentList.find( '.qodef-e' );

			if ( $items.length ) {
				$items.each(
					function () {
						var $item = $( this );
						var $links = $item.find( '.qodef-e-media-image a, .qodef-e-title-link, .qodef-button' );

						$links.on(
							'mouseenter',
							function () {
								$item.addClass( 'qodef--hover' );
							}
						).on(
							'mouseleave',
							function () {
								$item.removeClass( 'qodef--hover' );
							}
						);
					}
				);
			}
		},
	};

	qodefCore.shortcodes[shortcode].qodefBlogList = qodefBlogList;
	qodefCore.shortcodes[shortcode].qodefResizeIframes = qodef.qodefResizeIframes;

})( jQuery );
