<?php

if ( ! function_exists( 'cyberdom_core_add_locations_info_widget' ) ) {
	/**
	 * function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function cyberdom_core_add_locations_info_widget( $widgets ) {
		$widgets[] = 'CyberdomCore_Locations_Info_Widget';

		return $widgets;
	}

	add_filter( 'cyberdom_core_filter_register_widgets', 'cyberdom_core_add_locations_info_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class CyberdomCore_Locations_Info_Widget extends QodeFrameworkWidget {
		public $no_of_icons = 5;

		public function map_widget() {
			$this->set_base( 'cyberdom_core_locations_info' );
			$this->set_name( esc_html__( 'Cyberdom Locations Info', 'cyberdom-core' ) );
			$this->set_description( sprintf( esc_html__( 'Use this widget to add a group of up to %s locations to a widget area.', 'cyberdom-core' ), $this->no_of_icons ) );
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'widget_title',
					'title'      => esc_html__( 'Title', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'color',
					'name'       => 'locations_color',
					'title'      => esc_html__( 'Locations Color', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'locations_font_size',
					'title'      => esc_html__( 'Locations Font Size', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'locations_line_height',
					'title'      => esc_html__( 'Locations Line Height', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'select',
					'name'       => 'alignment',
					'title'      => esc_html__( 'Text Alignment', 'cyberdom-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'cyberdom-core' ),
						'center' => esc_html__( 'Center', 'cyberdom-core' ),
						'right' => esc_html__( 'Right', 'cyberdom-core' ),
					),
				)
			);
            $this->set_widget_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'appear_animation',
                    'title'         => esc_html__( 'Appear Animation', 'cyberdom-core' ),
                    'options'       => array(
                        'no'  => esc_html__( 'No', 'cyberdom-core' ),
                        'yes' => esc_html__( 'Yes', 'cyberdom-core' ),
                    ),
                    'default_value' => 'no'
                )
            );
            $this->set_widget_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'appear_animation_delay',
                    'title'      => esc_html__( 'Appear Animation Delay (ms)', 'cyberdom-core' ),
                    'dependency' => array(
                        'show' => array(
                            'appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );
			for ( $i = 1; $i <= $this->no_of_icons; $i ++ ) {
				$this->set_widget_option(
					array(
						'field_type' => 'text',
						'name'       => 'location_' . $i,
						'title'      => sprintf( esc_html__( 'Location %s', 'cyberdom-core' ), $i ),
					)
				);
			}
		}

		public function render( $atts ) { ?>
			<?php
			$locations_styles = array();

			if ( ! empty( $atts[ 'locations_color' ] ) ) {
				$locations_styles[] = 'color: ' . $atts[ 'locations_color' ];
			}

			if ( ! empty( $atts[ 'locations_font_size' ] ) ) {
				$locations_styles[] = 'font-size: ' . $atts[ 'locations_font_size' ];
			}

			if ( ! empty( $atts[ 'locations_line_height' ] ) ) {
				$locations_styles[] = 'line-height: ' . $atts[ 'locations_line_height' ];
			}

			if ( ! empty( $atts[ 'alignment' ] ) ) {
				$locations_styles[] = 'text-align: ' . $atts[ 'alignment' ];
			}

			if ( ! empty( $atts['appear_animation_delay'] ) ) {
			    $locations_styles[] = 'transition-delay: ' . $atts['appear_animation_delay'] . 'ms';
            }
			?>
			<div class="qodef-m-locations-info qodef-appear-animation--<?php echo esc_attr( $atts['appear_animation'] ); ?>" <?php qode_framework_inline_style( $locations_styles ); ?>>
				<?php cyberdom_core_render_svg_icon( 'globe', 'qodef-m-globe-icon' ); ?>
				<?php
				for ( $i = 1; $i <= $this->no_of_icons; $i ++ ) {

					if ( ! empty( $atts[ 'location_' . $i ] ) ) { ?>
						<div class="qodef-m-loaction-item">
							<p class="qodef-m-text">
								<?php echo esc_html( $atts[ 'location_' . $i ] ); ?>
							</p>
						</div>
					<?php
					}
				}
				?>
			</div>
			<?php
		}
	}
}
