(function ( $ ) {
    'use strict';

    $( window ).on(
        'load',
        function () {
            qodefLocationsInfo.init();
        }
    );

    const qodefLocationsInfo = {
        init () {
            this.widget = $('.qodef-m-locations-info');

            if ( this.widget.length ) {
                this.widget.each(
                    ( index, element ) => {
                        const $thisWidget = $( element );

                        if ( $thisWidget.hasClass('qodef-appear-animation--yes') ) {
                            qodefLocationsInfo.appearAnimation( $thisWidget );
                        }
                    }
                );
            }
        },
        appearAnimation ( $widget ) {
            qodefCore.qodefIsInViewport.check(
                $widget,
                () => {
                    $widget.addClass('qodef--appeared');
                }
            );
        }
    };

})( jQuery );
