<?php

if ( ! function_exists( 'cyberdom_core_add_contact_info_widget' ) ) {
	/**
	 * function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function cyberdom_core_add_contact_info_widget( $widgets ) {
		$widgets[] = 'CyberdomCore_Contact_Info_Widget';

		return $widgets;
	}

	add_filter( 'cyberdom_core_filter_register_widgets', 'cyberdom_core_add_contact_info_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class CyberdomCore_Contact_Info_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'cyberdom_core_contact_info' );
			$this->set_name( esc_html__( 'Cyberdom Contact Info', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Use this widget to add contact info.', 'cyberdom-core' ) );
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'widget_title',
					'title'      => esc_html__( 'Title', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'address',
					'title'      => esc_html__( 'Address', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'address_link',
					'title'      => esc_html__( 'Address Link', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'telephone',
					'title'      => esc_html__( 'Telephone', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'telephone_link',
					'title'      => esc_html__( 'Telephone Link', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'email',
					'title'      => esc_html__( 'Email', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'email_link',
					'title'      => esc_html__( 'Email Link', 'cyberdom-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'additional_info',
					'title'      => esc_html__( 'Additional Info', 'cyberdom-core' ),
				)
			);
		}

		public function render( $atts ) { ?>
			<div class="qodef-contact-info">

			<?php if ( ! empty( $atts['address'] ) ) { ?>
				<p class="qodef-contact-item qodef-contact-address">
				<?php if ( ! empty( $atts['address_link'] ) ) : ?>
					<a itemprop="url" href="<?php echo esc_url( $atts['address_link'] ); ?>" target="_blank">
				<?php endif; ?>
				<?php echo esc_html( $atts['address'] ); ?>
				<?php if ( ! empty( $atts['address_link'] ) ) : ?>
					</a>
				<?php endif; ?>
				</p>
			<?php } ?>

			<?php if ( ! empty( $atts['telephone'] ) ) { ?>
				<p class="qodef-contact-item qodef-contact-tel">
					<?php if ( ! empty( $atts['telephone_link'] ) ) : ?>
					<a itemprop="url" href="tel:<?php echo esc_url( $atts['telephone_link'] ); ?>" target="_blank">
						<?php endif; ?>
						<?php echo esc_html( $atts['telephone'] ); ?>
						<?php if ( ! empty( $atts['telephone_link'] ) ) : ?>
					</a>
				<?php endif; ?>
				</p>
			<?php } ?>

			<?php if ( ! empty( $atts['email'] ) ) { ?>
				<p class="qodef-contact-item qodef-contact-email">
					<?php if ( ! empty( $atts['email_link'] ) ) : ?>
					<a itemprop="url" href="mailto:<?php echo esc_url( $atts['email_link'] ); ?>" target="_blank">
						<?php endif; ?>
						<?php echo esc_html( $atts['email'] ); ?>
						<?php if ( ! empty( $atts['email_link'] ) ) : ?>
					</a>
				<?php endif; ?>
				</p>
			<?php } ?>

			<?php if ( ! empty( $atts['additional_info'] ) ) { ?>
				<p class="qodef-contact-item qodef-contact-additional-info">
					<?php echo esc_html( $atts['additional_info'] ); ?>
				</p>
			<?php } ?>

			</div>
			<?php
		}
	}
}
