<?php
// Load title image template
cyberdom_core_get_page_title_image();
?>
<div class="qodef-m-content <?php echo esc_attr( cyberdom_core_get_page_title_content_classes() ); ?>">
    <div class="qodef-m-title-holder">
        <<?php echo esc_attr( $title_tag ); ?> class="qodef-m-title entry-title">
            <?php
            if ( qode_framework_is_installed( 'theme' ) ) {
                echo esc_html( cyberdom_get_page_title_text() );
            } else {
                echo get_option( 'blogname' );
            }
            ?>
            <?php
            // Load subtitle template
            cyberdom_core_template_part( 'title/layouts/standard-with-shape', 'templates/parts/subtitle', '', cyberdom_core_get_standard_title_with_shape_layout_subtitle_text() );
            ?>
        </<?php echo esc_attr( $title_tag ); ?>>
    </div>
	<?php
	// Load shape
	$svg = cyberdom_core_get_post_value_through_levels( 'qodef_standard_with_shape_icon_svg_path' );
	if ( ! empty( $svg ) ) { ?>
		<div class="qodef-m-svg">
			<?php echo qode_framework_wp_kses_html( 'html', $svg ); ?>
		</div>
	<?php
	}
	?>
</div>
