<?php

if ( ! function_exists( 'cyberdom_core_add_cyberdom_spinner_layout_option' ) ) {
    /**
     * Function that set new value into page spinner layout options map
     *
     * @param array $layouts - module layouts
     *
     * @return array
     */
    function cyberdom_core_add_cyberdom_spinner_layout_option( $layouts ) {
        $layouts['cyberdom'] = esc_html__( 'Cyberdom', 'cyberdom-core' );

        return $layouts;
    }

    add_filter( 'cyberdom_core_filter_page_spinner_layout_options', 'cyberdom_core_add_cyberdom_spinner_layout_option' );
}

if ( ! function_exists( 'cyberdom_core_set_cyberdom_spinner_layout_as_default_option' ) ) {
    /**
     * Function that set default value for page spinner layout options map
     *
     * @param string $default_value
     *
     * @return string
     */
    function cyberdom_core_set_cyberdom_spinner_layout_as_default_option( $default_value ) {
        return 'cyberdom';
    }

    add_filter( 'cyberdom_core_filter_page_spinner_default_layout_option', 'cyberdom_core_set_cyberdom_spinner_layout_as_default_option' );
}
