<?php

if ( ! function_exists( 'cyberdom_core_add_page_spinner_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function cyberdom_core_add_page_spinner_options( $page ) {

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_page_spinner',
					'title'         => esc_html__( 'Enable Page Spinner', 'cyberdom-core' ),
					'description'   => esc_html__( 'Enable Page Spinner Effect', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$spinner_section = $page->add_section_element(
				array(
					'name'       => 'qodef_page_spinner_section',
					'title'      => esc_html__( 'Page Spinner Section', 'cyberdom-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_enable_page_spinner' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);

			$spinner_section->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_page_spinner_type',
					'title'         => esc_html__( 'Select Page Spinner Type', 'cyberdom-core' ),
					'description'   => esc_html__( 'Choose a page spinner animation style', 'cyberdom-core' ),
					'options'       => apply_filters( 'cyberdom_core_filter_page_spinner_layout_options', array() ),
					'default_value' => apply_filters( 'cyberdom_core_filter_page_spinner_default_layout_option', '' ),
				)
			);

			$spinner_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_spinner_background_color',
					'title'       => esc_html__( 'Spinner Background Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose the spinner background color', 'cyberdom-core' ),
				)
			);

			$spinner_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_spinner_color',
					'title'       => esc_html__( 'Spinner Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose the spinner color', 'cyberdom-core' ),
				)
			);

            $spinner_section->add_field_element(
                array(
                    'field_type'    => 'text',
                    'name'          => 'qodef_page_spinner_text',
                    'title'         => esc_html__( 'Spinner Text', 'cyberdom-core' ),
                    'description'   => esc_html__( 'Enter the spinner text', 'cyberdom-core' ),
                    'default_value' => 'CYBERDOM',
                    'dependency'    => array(
                        'show' => array(
                            'qodef_page_spinner_type' => array(
                                'values'        => 'cyberdom',
                                'default_value' => ''
                            )
                        )
                    )
                )
            );

			$spinner_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_page_spinner_fade_out_animation',
					'title'         => esc_html__( 'Enable Fade Out Animation', 'cyberdom-core' ),
					'description'   => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);
		}
	}

	add_action( 'cyberdom_core_action_after_general_options_map', 'cyberdom_core_add_page_spinner_options' );
}
