<?php

if ( ! function_exists( 'cyberdom_core_add_social_share_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function cyberdom_core_add_social_share_widget( $widgets ) {
		$widgets[] = 'CyberdomCore_Social_Share_Widget';

		return $widgets;
	}

	add_filter( 'cyberdom_core_filter_register_widgets', 'cyberdom_core_add_social_share_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class CyberdomCore_Social_Share_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'cyberdom_core_social_share',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'cyberdom_core_social_share' );
				$this->set_name( esc_html__( 'Cyberdom Social Share', 'cyberdom-core' ) );
				$this->set_description( esc_html__( 'Add a social share element into widget areas', 'cyberdom-core' ) );
			}
		}

		public function render( $atts ) {
			echo CyberdomCore_Social_Share_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
