<?php

if ( ! function_exists( 'cyberdom_core_add_video_button_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_video_button_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Video_Button_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_video_button_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Video_Button_Shortcode extends CyberdomCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/video-button' );
			$this->set_base( 'cyberdom_core_video_button' );
			$this->set_name( esc_html__( 'Video Button', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds video button element', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_scripts(
				array(
					'jquery-magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_necessary_styles(
				array(
					'magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'video_link',
					'title'      => esc_html__( 'Video Link', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'video_button_text',
					'title'      => esc_html__( 'Button Text', 'cyberdom-core' ),
					'default_value' => esc_html__( 'Watch Video', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'video_button_line_break_positions',
					'title'       => esc_html__( 'Positions of Line Break', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break for circle button. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'video_button_disable_text_break_words',
					'title'         => esc_html__( 'Disable Text Line Break', 'cyberdom-core' ),
					'description'   => esc_html__( 'Enabling this option will disable text line breaks for screen size 1024 and lower for circle button', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'image',
					'name'        => 'video_image',
					'title'       => esc_html__( 'Image', 'cyberdom-core' ),
					'description' => esc_html__( 'Select image from media library', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'play_button_color',
					'title'      => esc_html__( 'Play Button Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'play_button_size',
					'title'      => esc_html__( 'Play Button Size (px)', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'cyberdom_core_video_button', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			wp_enqueue_style( 'magnific-popup' );
			wp_enqueue_script( 'jquery-magnific-popup' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']     = $this->get_holder_classes( $atts );
			$atts['play_button_styles'] = $this->get_play_button_styles( $atts );

			return cyberdom_core_get_template_part( 'shortcodes/video-button', 'templates/video-button', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-video-button';
			$holder_classes[] = ! empty( $atts['video_image'] ) ? 'qodef--has-img' : '';

			return implode( ' ', $holder_classes );
		}

		private function get_play_button_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['play_button_color'] ) ) {
				$styles[] = 'color: ' . $atts['play_button_color'];
			}

			if ( ! empty( $atts['play_button_size'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['play_button_size'] ) ) {
					$styles[] = 'font-size: ' . $atts['play_button_size'];
				} else {
					$styles[] = 'font-size: ' . intval( $atts['play_button_size'] ) . 'px';
				}
			}

			return implode( ';', $styles );
		}
	}
}
