(function ($) {
    'use strict';

	qodefCore.shortcodes.cyberdom_core_vertical_split_slider = {};

    $(document).ready(function () {
        qodefVerticalSplitSlider.init();
    });

    var qodefVerticalSplitSlider = {
        init: function () {
            var $holder = $('.qodef-vertical-split-slider'),
                $headerInner = $('#qodef-page-header-inner'),
                breakpoint = qodefVerticalSplitSlider.getBreakpoint($holder),
                initialHeaderStyle = '',
                initialLogoStyle = '';

            if ($headerInner.hasClass('qodef-skin--light')) {
                initialHeaderStyle = 'light';
            } else if ($headerInner.hasClass('qodef-skin--dark')) {
                initialHeaderStyle = 'dark';
            }

            if ($headerInner.hasClass('qodef-logo-skin--light')) {
                initialLogoStyle = 'light';
            } else if ($headerInner.hasClass('qodef-logo-skin--dark')) {
                initialLogoStyle = 'dark';
            }

            if ($holder.length) {
                $holder.multiscroll({
                    navigation: true,
                    navigationPosition: 'right',
					loopBottom: false,
					loopTop: false,
					easing: 'easeOutQuart',
					scrollingSpeed: 1200,
                    afterRender: function () {
                        $holder.addClass('qodef--init');
						qodefCore.body.addClass('qodef-vertical-split-slider--initialized');
                        qodefCore.html.addClass('qodef-vertical-split-slider--initialized');
						qodefVerticalSplitSlider.headerClassHandler($('.ms-left .ms-section:first-child').data('header-skin'), initialHeaderStyle, $headerInner);
						qodefVerticalSplitSlider.logoClassHandler($('.ms-left .ms-section:first-child').data('logo-skin'), initialLogoStyle, $headerInner);
                    },
                    onLeave: function (index, nextIndex) {
                        qodefVerticalSplitSlider.headerClassHandler($($('.ms-left .ms-section')[nextIndex - 1]).data('header-skin'), initialHeaderStyle, $headerInner);
                        qodefVerticalSplitSlider.logoClassHandler($($('.ms-left .ms-section')[nextIndex - 1]).data('logo-skin'), initialLogoStyle, $headerInner);
                    }
                });

                $holder.height(qodefCore.windowHeight);
                qodefVerticalSplitSlider.buildAndDestroy(breakpoint);

                $(window).resize(function () {
                    qodefVerticalSplitSlider.buildAndDestroy(breakpoint);
                });
            }
        },
        getBreakpoint: function ($holder) {
            if ($holder.hasClass('qodef-disable-below--768')) {
                return 768;
            } else {
                return 1024;
            }
        },
        buildAndDestroy: function (breakpoint) {
            if (qodefCore.windowWidth <= breakpoint) {
                $.fn.multiscroll.destroy();
                $('html, body').css('overflow', 'initial');
                qodefCore.body.removeClass('qodef-vertical-split-slider--initialized');
            } else {
                $.fn.multiscroll.build();
            }
        },
        headerClassHandler: function (slideHeaderStyle, initialHeaderStyle, $headerInner) {
            var $controls = $('#multiscroll-nav'),
            $scrollIcon = $('.qodef-m-scroll-icon');
            
            if (slideHeaderStyle !== undefined && slideHeaderStyle !== '') {
                $headerInner.removeClass('qodef-skin--light qodef-skin--dark').addClass('qodef-skin--' + slideHeaderStyle);
    
                if ($controls.length) {
                    $controls.removeClass('qodef-skin--light qodef-skin--dark').addClass('qodef-skin--' + slideHeaderStyle);
                }
                
                if ($scrollIcon.length) {
                    $scrollIcon.removeClass('qodef-skin--light qodef-skin--dark').addClass('qodef-skin--' + slideHeaderStyle);
                }
                
            } else if (initialHeaderStyle !== '') {
                $headerInner.removeClass('qodef-skin--light qodef-skin--dark').addClass('qodef-skin--' + slideHeaderStyle);
    
                if ($controls.length) {
                    $controls.removeClass('qodef-skin--light qodef-skin--dark').addClass('qodef-skin--' + slideHeaderStyle);
                }
                
                if ($scrollIcon.length) {
                    $scrollIcon.removeClass('qodef-skin--light qodef-skin--dark').addClass('qodef-skin--' + slideHeaderStyle);
                }
                
            } else {
                $headerInner.removeClass('qodef-skin--light qodef-skin--dark');
    
                if ($controls.length) {
                    $controls.removeClass('qodef-skin--light qodef-skin--dark');
                }
                
                if ($scrollIcon.length) {
                    $scrollIcon.removeClass('qodef-skin--light qodef-skin--dark');
                }
            }
        },
        logoClassHandler: function (slideHeaderStyle, initialLogoStyle, $headerInner) {

            if (slideHeaderStyle !== undefined && slideHeaderStyle !== '') {
                $headerInner.removeClass('qodef-logo-skin--light qodef-logo-skin--dark').addClass('qodef-logo-skin--' + slideHeaderStyle);
            } else if (initialLogoStyle !== '') {
                $headerInner.removeClass('qodef-logo-skin--light qodef-logo-skin--dark').addClass('qodef-logo-skin--' + slideHeaderStyle);
            } else {
                $headerInner.removeClass('qodef-logo-skin--light qodef-logo-skin--dark');
            }
        }
    };

	qodefCore.shortcodes.cyberdom_core_vertical_split_slider.qodefVerticalSplitSlider = qodefVerticalSplitSlider;

})(jQuery);
