(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_tabs = {};

	$( document ).ready(
		function () {
			qodefTabs.init();
		}
	);

	var qodefTabs = {
		init: function () {
			this.holder = $( '.qodef-tabs' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefTabs.itemInit( $( this ) );
						qodefTabs.setHeight( $( this ) );
					}
				);
			}
		},
		itemInit: function ( $currentItem ) {
			$currentItem.children( '.qodef-tabs-content' ).each(
				function ( index ) {
					index = index + 1;

					var $that    = $( this ),
						link     = $that.attr( 'id' ),
						$navItem = $that.parent().find( '.qodef-tabs-navigation li:nth-child(' + index + ') a' ),
						navLink  = $navItem.attr( 'href' );

					link = '#' + link;

					if ( link.indexOf( navLink ) > -1 ) {
						$navItem.attr(
							'href',
							link
						);
					}
				}
			);

			$currentItem.addClass( 'qodef--init' ).tabs();
		},
		setHeight ( $holder ) {
			const $navigation = $holder.find('.qodef-tabs-navigation');
			const $content    = $holder.find('.qodef-tabs-content');
			let   navHeight,
				contentHeight,
				maxContentHeight = 0;

			if ( $navigation.length ) {
				navHeight = $navigation.outerHeight(true);
			}

			if ( $content.length ) {
				$content.each(
					( index, element ) => {
						contentHeight = $( element ).outerHeight(true);
						maxContentHeight = contentHeight > maxContentHeight ? contentHeight : maxContentHeight;
					}
				)
			}

			$holder.height(navHeight + maxContentHeight);
		}
	};

	qodefCore.shortcodes.cyberdom_core_tabs.qodefTabs = qodefTabs;

})( jQuery );
