<?php

if ( ! function_exists( 'cyberdom_core_add_single_image_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function cyberdom_core_add_single_image_widget( $widgets ) {
		$widgets[] = 'CyberdomCore_Single_Image_Widget';

		return $widgets;
	}

	add_filter( 'cyberdom_core_filter_register_widgets', 'cyberdom_core_add_single_image_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class CyberdomCore_Single_Image_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'cyberdom_core_single_image',
					'exclude'        => array( 'custom_class', 'parallax_item' ),
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'cyberdom_core_single_image' );
				$this->set_name( esc_html__( 'Cyberdom Single Image', 'cyberdom-core' ) );
				$this->set_description( esc_html__( 'Add a single image element into widget areas', 'cyberdom-core' ) );
			}
		}

		public function render( $atts ) {
			echo CyberdomCore_Single_Image_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
