<?php

if ( ! function_exists( 'cyberdom_core_add_single_image_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function cyberdom_core_add_single_image_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Single_Image_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_single_image_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Single_Image_Shortcode extends CyberdomCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_single_image_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_single_image_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/single-image' );
			$this->set_base( 'cyberdom_core_single_image' );
			$this->set_name( esc_html__( 'Single Image', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds image element', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_scripts(
				array(
					'jquery-magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_necessary_styles(
				array(
					'magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
				)
			);

			$options_map = cyberdom_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'cyberdom-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'image',
					'title'      => esc_html__( 'Image', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'retina_scaling',
					'title'         => esc_html__( 'Enable Retina Scaling', 'cyberdom-core' ),
					'description'   => esc_html__( 'Image uploaded should be two times the height.', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'images_proportion',
					'default_value' => 'full',
					'title'         => esc_html__( 'Image Proportions', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'list_image_dimension', false ),
					'dependency'    => array(
						'hide' => array(
							'retina_scaling' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'custom_image_width',
					'title'       => esc_html__( 'Custom Image Width', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter image width in px', 'cyberdom-core' ),
					'dependency'  => array(
						'show' => array(
							'images_proportion' => array(
								'values'        => 'custom',
								'default_value' => 'full',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'custom_image_height',
					'title'       => esc_html__( 'Custom Image Height', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter image height in px', 'cyberdom-core' ),
					'dependency'  => array(
						'show' => array(
							'images_proportion' => array(
								'values'        => 'custom',
								'default_value' => 'full',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_action',
					'title'      => esc_html__( 'Image Action', 'cyberdom-core' ),
					'options'    => array(
						''            => esc_html__( 'No Action', 'cyberdom-core' ),
						'open-popup'  => esc_html__( 'Open Popup', 'cyberdom-core' ),
						'custom-link' => esc_html__( 'Custom Link', 'cyberdom-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Custom Link', 'cyberdom-core' ),
					'dependency' => array(
						'show' => array(
							'image_action' => array(
								'values'        => array( 'custom-link' ),
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'dependency'    => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'parallax_item',
					'title'         => esc_html__( 'Enable Parallax Item', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no' ),
					'default_value' => '',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'description_text',
					'title'         => esc_html__( 'Description Text', 'cyberdom-core' ),
				)
			);

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'enable_appear_animation',
                    'title'         => esc_html__( 'Enable Appear Animation', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                    'group'         => esc_html__( 'Animation Options', 'cyberdom-core' )
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'appear_animation_direction',
                    'title'         => esc_html__( 'Appear Animation Direction', 'cyberdom-core' ),
                    'options'       => array(
                        'right' => esc_html__( 'Right', 'cyberdom-core' ),
                        'left'  => esc_html__( 'Left', 'cyberdom-core' ),
                        'up'    => esc_html__( 'Up', 'cyberdom-core' ),
                        'spin'  => esc_html__( 'Spin', 'cyberdom-core' )
                    ),
                    'default_value' => 'right',
                    'dependency'    => array(
                        'show' => array(
                            'enable_appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                    'group'         => esc_html__( 'Animation Options', 'cyberdom-core' )
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'appear_animation_delay',
                    'title'      => esc_html__( 'Appear Animation Delay (ms)', 'cyberdom-core' ),
                    'dependency' => array(
                        'show' => array(
                            'enable_appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                    'group'      => esc_html__( 'Animation Options', 'cyberdom-core' )
                )
            );

			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'cyberdom_core_single_image', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {

			if ( isset( $atts['image_action'] ) && 'open-popup' === $atts['image_action'] ) {
				wp_enqueue_style( 'magnific-popup' );
				wp_enqueue_script( 'jquery-magnific-popup' );
			}
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['image_styles']   = $this->get_image_styles( $atts );

			return cyberdom_core_get_template_part( 'shortcodes/single-image', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-single-image';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['parallax_item'] ) && ( 'yes' === $atts['parallax_item'] ) ? 'qodef-parallax-item' : '';
			$holder_classes[] = ( 'yes' === $atts['retina_scaling'] ) ? 'qodef--retina' : '';
            $holder_classes[] = ! empty( $atts['enable_appear_animation'] ) ? 'qodef-appear-animation--' . $atts['enable_appear_animation'] : '';
            $holder_classes[] = ! empty( $atts['appear_animation_direction'] ) ? 'qodef-appear-animation-direction--' . $atts['appear_animation_direction'] : '';

			return implode( ' ', $holder_classes );
		}

        private function get_image_styles( $atts ) {
            $styles = array();

            if ( ! empty( $atts['appear_animation_delay'] ) ) {
                $styles[] = 'transition-delay: ' . $atts['appear_animation_delay'] . 'ms';
            }

            return $styles;
        }
	}
}
