(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_single_image = {};

	$( window ).on(
		'load',
		() => {
			qodefSingleImage.init();
		}
	);

	const qodefSingleImage = {
		init () {
			this.shortcode = $('.qodef-single-image');

			if ( this.shortcode.length ) {
				this.shortcode.each(
					( index, element ) => {
						const $thisShortcode = $( element );

						if ( $thisShortcode.hasClass('qodef-appear-animation--yes') ) {
							qodefSingleImage.appearAnimation( $thisShortcode );
						}
					}
				);
			}
		},
		appearAnimation ( $holder ) {
			qodefCore.qodefIsInViewport.check(
				$holder,
				() => {
					$holder.addClass('qodef--appeared');
				}
			);
		}
	};

	qodefCore.shortcodes.cyberdom_core_single_image.qodefSingleImage   = qodefSingleImage;
	qodefCore.shortcodes.cyberdom_core_single_image.qodefMagnificPopup = qodef.qodefMagnificPopup;

})( jQuery );
