(function ( $ ) {
    'use strict';

    qodefCore.shortcodes.cyberdom_core_section_title = {};

    $( window ).on(
        'load',
        () => {
            qodefSectionTitle.init();
        }
    );

    const qodefSectionTitle = {
        init () {
            this.shortcode = $('.qodef-section-title');

            if ( this.shortcode.length ) {
                this.shortcode.each(
                    ( index, element ) => {
                        const $thisShortcode = $( element );

                        if ( $thisShortcode.hasClass('qodef-appear-animation--yes') ) {
                            qodefSectionTitle.appearAnimation( $thisShortcode );
                        }
                    }
                );
            }
        },
        appearAnimation ( $holder ) {
            if ( $holder.hasClass('qodef-wait-for-trigger') ) {
                const interval = setInterval(
                    () => {
                        if ( qodef.body.hasClass('qodef-spinner--end') ) {
                            setTimeout(
                                () => {
                                    $holder.addClass( 'qodef--appeared' );
                                }, 200
                            );
                            clearInterval(interval);
                        }
                    }, 100
                );
            } else {
                qodefCore.qodefIsInViewport.check(
                    $holder,
                    () => {
                        $holder.addClass( 'qodef--appeared' );
                    }
                );
            }
        }
    };

    qodefCore.shortcodes.cyberdom_core_section_title.qodefSectionTitle = qodefSectionTitle;

})( jQuery );
