(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_progress_bar = {};

	$( document ).ready(
		function () {
			qodefProgressBar.init();
		}
	);

	/**
	 * Init progress bar shortcode functionality
	 */
	var qodefProgressBar = {
		init: function () {
			this.holder = $( '.qodef-progress-bar' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefProgressBar.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var layout = $currentItem.data( 'layout' );

			qodefCore.qodefIsInViewport.check(
				$currentItem,
				function () {
					$currentItem.addClass( 'qodef--init' );

					var $container = $currentItem.find( '.qodef-m-canvas' ),
						data       = qodefProgressBar.generateBarData( $currentItem, layout ),
						number     = $currentItem.data( 'number' ) / 100;

					switch (layout) {
						case 'circle':
							qodefProgressBar.initCircleBar( $container, data, number, $currentItem );
							break;
						case 'semi-circle':
							qodefProgressBar.initSemiCircleBar( $container, data, number, $currentItem );
							break;
						case 'line':
							data = qodefProgressBar.generateLineData( $currentItem, number );
							qodefProgressBar.initLineBar( $container, data );
							break;
						case 'custom':
							qodefProgressBar.initCustomBar( $container, data, number );
							break;
					}
				}
			);
		},
		generateBarData: function ( thisBar, layout ) {
			var activeWidth   = thisBar.data( 'active-line-width' );
			var activeColor   = thisBar.data( 'active-line-color' );
			var inactiveWidth = thisBar.data( 'inactive-line-width' );
			var inactiveColor = thisBar.data( 'inactive-line-color' );
			var easing        = 'linear';
			var duration      = typeof thisBar.data( 'duration' ) !== 'undefined' && thisBar.data( 'duration' ) !== '' ? parseInt( thisBar.data( 'duration' ), 10 ) : 1600;
			var textColor     = thisBar.data( 'text-color' );

			return {
				strokeWidth: activeWidth,
				color: activeColor,
				trailWidth: inactiveWidth,
				trailColor: inactiveColor,
				easing: easing,
				duration: duration,
				svgStyle: {
					width: '100%',
					height: '100%'
				},
				text: {
					style: {
						color: textColor
					},
					autoStyleContainer: false
				},
				from: {
					color: inactiveColor
				},
				to: {
					color: activeColor
				},
				step: function ( state, bar ) {
					if ( layout !== 'custom' ) {
						bar.setText( Math.round( bar.value() * 100 ) + '%' );
					}
				},
			};
		},
		generateLineData: function ( thisBar, number ) {
			var height         = thisBar.data( 'active-line-width' );
			var activeColor    = thisBar.data( 'active-line-color' );
			var inactiveHeight = thisBar.data( 'inactive-line-width' );
			var inactiveColor  = thisBar.data( 'inactive-line-color' );
			var duration       = typeof thisBar.data( 'duration' ) !== 'undefined' && thisBar.data( 'duration' ) !== '' ? parseInt( thisBar.data( 'duration' ), 10 ) : 1600;
			var textColor      = thisBar.data( 'text-color' );

			return {
				percentage: number * 100,
				duration: duration,
				fillBackgroundColor: activeColor,
				backgroundColor: inactiveColor,
				height: height,
				inactiveHeight: inactiveHeight,
				followText: thisBar.hasClass( 'qodef-percentage--floating' ),
				textColor: textColor,
			};
		},
		initCircleBar: function ( $container, data, number, $holder ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.Circle( $container[0], data );

				/* adding hidden svg for gradient background */
				if ( $holder.hasClass('qodef-use-gradient-bg--yes') ) {

					$container.parent('.qodef-m-inner').prepend('<div class="qodef-gradient-bg-hidden">\n' +
						'\t\t\t\t<svg viewBox="0 0 100 100" style="width: 100%; height: 100%;">\n' +
						'\t\t\t\t\t<defs>\n' +
						'\t\t\t\t\t\t<linearGradient id="qodefGradientBackgroundProgress" x1="0" x2="0" y1="0" y2="1">\n' +
						'\t\t\t\t\t\t\t<stop offset="0%" stop-color="var(--qode-gradient-color-one)"></stop>\n' +
						'\t\t\t\t\t\t\t<stop offset="40%" stop-color="var(--qode-gradient-color-middle)"></stop>\n' +
						'\t\t\t\t\t\t\t<stop offset="60%" stop-color="var(--qode-gradient-color-middle)"></stop>\n' +
						'\t\t\t\t\t\t\t<stop offset="100%" stop-color="var(--qode-gradient-color-two)"></stop>\n' +
						'\t\t\t\t\t\t</linearGradient>\n' +
						'\t\t\t\t\t</defs>\n' +
						'\t\t\t\t\t<path d="M 50,50 m 0,-49 a 49,49 0 1 1 0,98 a 49,49 0 1 1 0,-98" stroke="#bebebe" stroke-width="2" fill-opacity="0"></path>\n' +
						'\t\t\t\t\t<path d="M 50,50 m 0,-49 a 49,49 0 1 1 0,98 a 49,49 0 1 1 0,-98" stroke="url(#qodefGradientBackgroundProgress)" stroke-width="2" fill-opacity="0" style="stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 76.9799;"></path>\n' +
						'\t\t\t\t</svg>\n' +
						'\t\t\t</div>');
				}

				$bar.animate( number );
			}
		},
		initSemiCircleBar: function ( $container, data, number, $holder ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.SemiCircle( $container[0], data );

				/* adding hidden svg for gradient background */
				if ( $holder.hasClass('qodef-use-gradient-bg--yes') ) {

					$container.parent('.qodef-m-inner').prepend('<div class="qodef-gradient-bg-hidden">\n' +
						'\t\t\t\t<svg viewBox="0 0 100 100" style="width: 100%; height: 100%;">\n' +
						'\t\t\t\t\t<defs>\n' +
						'\t\t\t\t\t\t<linearGradient id="qodefGradientBackgroundProgress" x1="0" x2="0" y1="0" y2="1">\n' +
						'\t\t\t\t\t\t\t<stop offset="0%" stop-color="var(--qode-gradient-color-one)"></stop>\n' +
						'\t\t\t\t\t\t\t<stop offset="40%" stop-color="var(--qode-gradient-color-middle)"></stop>\n' +
						'\t\t\t\t\t\t\t<stop offset="60%" stop-color="var(--qode-gradient-color-middle)"></stop>\n' +
						'\t\t\t\t\t\t\t<stop offset="100%" stop-color="var(--qode-gradient-color-two)"></stop>\n' +
						'\t\t\t\t\t\t</linearGradient>\n' +
						'\t\t\t\t\t</defs>\n' +
						'\t\t\t\t\t<path d="M 50,50 m 0,-49 a 49,49 0 1 1 0,98 a 49,49 0 1 1 0,-98" stroke="#bebebe" stroke-width="2" fill-opacity="0"></path>\n' +
						'\t\t\t\t\t<path d="M 50,50 m 0,-49 a 49,49 0 1 1 0,98 a 49,49 0 1 1 0,-98" stroke="url(#qodefGradientBackgroundProgress)" stroke-width="2" fill-opacity="0" style="stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 76.9799;"></path>\n' +
						'\t\t\t\t</svg>\n' +
						'\t\t\t</div>');
				}

				$bar.animate( number );
			}
		},
		initCustomBar: function ( $container, data, number ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.Path( $container[0], data );

				$bar.set( 0 );
				$bar.animate( number );
			}
		},
		initLineBar: function ( $container, data ) {
			$container.LineProgressbar( data );
		},
		checkBar: function ( $container ) {
			// check if svg is already in container, elementor fix
			if ( $container.find( 'svg' ).length ) {
				return false;
			}

			return true;
		}
	};

	qodefCore.shortcodes.cyberdom_core_progress_bar.qodefProgressBar = qodefProgressBar;

})( jQuery );
