<?php

if ( ! function_exists( 'cyberdom_core_add_number_item_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_number_item_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Number_Item_Shortcode';
		
		return $shortcodes;
	}
	
	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_number_item_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Number_Item_Shortcode extends CyberdomCore_Shortcode {
		
		public function __construct() {
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_number_item_layouts', array() ) );
			
			$options_map = cyberdom_core_get_variations_options_map( $this->get_layouts() );
			$default_value = $options_map['default_value'];
			
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_number_item_extra_options', array(), $default_value ) );
			
			parent::__construct();
		}
		
		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/number-item' );
			$this->set_base( 'cyberdom_core_number_item' );
			$this->set_name( esc_html__( 'Number Item', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds number item element', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
			) );
			
			$options_map = cyberdom_core_get_variations_options_map( $this->get_layouts() );
			
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'layout',
				'title'         => esc_html__( 'Layout', 'cyberdom-core' ),
				'options'		=> $this->get_layouts(),
				'default_value' => $options_map['default_value'],
				'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] )
			) );
			$this->set_option( array(
				'field_type'    => 'text',
				'name'          => 'link',
				'title'         => esc_html__( 'Link', 'cyberdom-core' ),
				'default_value' => ''
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'target',
				'title'         => esc_html__( 'Link Target', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
				'default_value' => '_self'
			) );
            $this->set_option( array(
                'field_type' => 'text',
                'name'       => 'number',
                'title'      => esc_html__( 'Number', 'cyberdom-core' ),
                'group'      => esc_html__( 'Content', 'cyberdom-core' )
            ) );
            $this->set_option( array(
                'field_type' => 'text',
                'name'       => 'number_font_size',
                'title'      => esc_html__( 'Number Font Size (px or em)', 'cyberdom-core' ),
                'group'      => esc_html__( 'Content', 'cyberdom-core' )
            ) );
            $this->set_option( array(
                'field_type' => 'color',
                'name'       => 'number_color',
                'title'      => esc_html__( 'Number Color', 'cyberdom-core' ),
                'group'      => esc_html__( 'Content', 'cyberdom-core' )
            ) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'title',
				'title'      => esc_html__( 'Title', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'title_tag',
				'title'         => esc_html__( 'Title Tag', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'title_tag' ),
				'default_value' => 'h5',
				'group'         => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'title_color',
				'title'      => esc_html__( 'Title Color', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'title_margin_top',
				'title'      => esc_html__( 'Title Margin Top', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'textarea',
				'name'       => 'text',
				'title'      => esc_html__( 'Subtitle', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'text_color',
				'title'      => esc_html__( 'Subtitle Color', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'text_margin_top',
				'title'      => esc_html__( 'Subtitle Margin Top', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'enable_appear',
				'title'         => esc_html__( 'Appear Animation', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
				'default_value' => 'no'
			) );
			$this->map_extra_options();
		}
		
		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();
			
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['number_styles']  = $this->get_number_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );
			$atts['animation_data'] = $this->get_animation_data( $atts );
			
			return cyberdom_core_get_template_part( 'shortcodes/number-item', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}
		
		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();
			
			$holder_classes[] = 'qodef-number-item';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--has-appear qodef--splitting' : '';
			
			$holder_classes = apply_filters( 'cyberdom_core_filter_number_item_variation_classes', $holder_classes, $atts );
			
			return implode( ' ', $holder_classes );
		}
		
		private function get_animation_data( $atts ) {
			$animation_data = array();
			
			$animation_data[] = ( ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes') ? 'data-splitting' : '';
			
			return implode( ' ', $animation_data );
		}
		
		private function get_title_styles( $atts ) {
			$styles = array();
			
			if ( $atts['title_margin_top'] !== '' ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}
			
			return $styles;
		}

        private function get_number_styles( $atts ) {
            $styles = array();


            if ( ! empty( $atts['number_font_size'] ) ) {
                $styles[] = 'font-size: ' . $atts['number_font_size'];
            }

            if ( ! empty( $atts['number_color'] ) ) {
                $styles[] = 'color: ' . $atts['number_color'];
            }

            return $styles;
        }
		
		private function get_text_styles( $atts ) {
			$styles = array();
			
			if ( $atts['text_margin_top'] !== '' ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}
			
			return $styles;
		}
	}
}
