<?php

if ( ! function_exists( 'cyberdom_core_add_image_with_text_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_image_with_text_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Image_With_Text_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_image_with_text_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Image_With_Text_Shortcode extends CyberdomCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_image_with_text_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_image_with_text_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/image-with-text' );
			$this->set_base( 'cyberdom_core_image_with_text' );
			$this->set_name( esc_html__( 'Image With Text', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds image with text element', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_scripts(
				array(
					'jquery-magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_necessary_styles(
				array(
					'magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
				)
			);

			$options_map = cyberdom_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'cyberdom-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_left',
					'title'      => esc_html__( 'Image on left', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'image',
					'title'      => esc_html__( 'Image', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'image_size',
					'title'       => esc_html__( 'Image Size', 'cyberdom-core' ),
					'description' => esc_html__( 'For predefined image sizes input thumbnail, medium, large or full. If you wish to set a custom image size, type in the desired image dimensions in pixels (e.g. 400x400).', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'image_shadow',
					'title'         => esc_html__( 'Image Shadow', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes' ),
					'default_value' => 'yes',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_action',
					'title'      => esc_html__( 'Image Action', 'cyberdom-core' ),
					'options'    => array(
						''            => esc_html__( 'No Action', 'cyberdom-core' ),
						'open-popup'  => esc_html__( 'Open Popup', 'cyberdom-core' ),
						'custom-link' => esc_html__( 'Custom Link', 'cyberdom-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Custom Link', 'cyberdom-core' ),
					'dependency' => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'dependency'    => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'subtitle',
					'title'         => esc_html__( 'Subtitle', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle_margin_bottom',
					'title'      => esc_html__( 'Subtitle Margin Bottom', 'cyberdom-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'cyberdom-core' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_alignment',
					'title'      => esc_html__( 'Content Alignment', 'cyberdom-core' ),
					'options'    => array(
						''       => esc_html__( 'Default', 'cyberdom-core' ),
						'left'   => esc_html__( 'Left', 'cyberdom-core' ),
						'center' => esc_html__( 'Center', 'cyberdom-core' ),
						'right'  => esc_html__( 'Right', 'cyberdom-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'title_tag', true, '', array('span' => 'SPAN') ),
					'default_value' => 'h4',
					'group'         => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'cyberdom-core' ),
					'group'      => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_max_width',
					'title'      => esc_html__( 'Title Max Width', 'cyberdom-core' ),
					'group'      => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'description',
					'title'         => esc_html__( 'Text', 'cyberdom-core' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Text Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'cyberdom-core' ),
					'group'      => esc_html__( 'Text Style', 'cyberdom-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_max_width',
					'title'      => esc_html__( 'Text Max Width', 'cyberdom-core' ),
					'group'      => esc_html__( 'Text Style', 'cyberdom-core' ),
				)
			);

			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'cyberdom_core_button',
					'exclude'           => array( 'custom_class' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'cyberdom-core' ),
					),
				)
			);

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'enable_appear_animation',
                    'title'         => esc_html__( 'Enable Appear Animation', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                    'group'         => esc_html__( 'Animation Options', 'cyberdom-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'wait_for_trigger',
                    'title'         => esc_html__( 'Wait For Trigger', 'cyberdom-core' ),
                    'description'   => esc_html__( 'Enabling this option will delay appear animation until external trigger is activated', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'no',
                    'dependency'    => array(
                        'show' => array(
                            'enable_appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                    'group'         => esc_html__( 'Animation Options', 'cyberdom-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'appear_animation_delay',
                    'title'      => esc_html__( 'Appear Animation Delay (ms)', 'cyberdom-core' ),
                    'group'      => esc_html__( 'Animation Options', 'cyberdom-core' ),
                    'dependency' => array(
                        'show' => array(
                            'enable_appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'cyberdom_core_image_with_text', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			$atts = $this->get_atts();

			if ( isset( $atts['image_action'] ) && 'open-popup' === $atts['image_action'] ) {
				wp_enqueue_style( 'magnific-popup' );
				wp_enqueue_script( 'jquery-magnific-popup' );
			}
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']         = $this->get_holder_classes( $atts );
            $atts['holder_data']            = $this->get_holder_data( $atts );
            $atts['subtitle_holder_styles'] = $this->get_subtitle_holder_styles( $atts );
            $atts['title_holder_styles']    = $this->get_title_holder_styles( $atts );
            $atts['text_holder_styles']     = $this->get_text_holder_styles( $atts );
			$atts['subtitle_styles']        = $this->get_subtitle_styles( $atts );
			$atts['title_styles']           = $this->get_title_styles( $atts );
			$atts['text_styles']            = $this->get_text_styles( $atts );
			$atts['button_params']          = $this->generate_button_params( $atts );
			$atts['image_params']           = $this->generate_image_params( $atts );

			return cyberdom_core_get_template_part( 'shortcodes/image-with-text', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-image-with-text';
			$holder_classes[] = 'yes' === $atts['image_left'] ? 'qodef-image-on-left' : '';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['image_shadow'] ) ? 'qodef-image-shadow--' . $atts['image_shadow'] : '';
			$holder_classes[] = ! empty( $atts['content_alignment'] ) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';
            $holder_classes[] = ! empty( $atts['enable_appear_animation'] ) ? 'qodef-appear-animation--' . $atts['enable_appear_animation'] : '';
            $holder_classes[] = ! empty( $atts['wait_for_trigger'] ) && 'yes' === $atts['wait_for_trigger'] ? 'qodef-wait-for-trigger' : '';

			return implode( ' ', $holder_classes );
		}

        private function get_holder_data( $atts ) {
            $data = array();

            $data['data-appearing-delay'] = ! empty( $atts['appear_animation_delay'] ) ? intval( $atts['appear_animation_delay'] ) : 0;

            return $data;
        }

        private function get_subtitle_holder_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['subtitle_margin_bottom'] ) {
                if ( qode_framework_string_ends_with_space_units( $atts['subtitle_margin_bottom'] ) ) {
                    $styles[] = 'margin-bottom: ' . $atts['subtitle_margin_bottom'];
                } else {
                    $styles[] = 'margin-bottom: ' . intval( $atts['subtitle_margin_bottom'] ) . 'px';
                }
            }

            return $styles;
        }

		private function get_subtitle_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['subtitle_color'] ) ) {
				$styles[] = 'color: ' . $atts['subtitle_color'];
			}

			return $styles;
		}

        private function get_title_holder_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['title_margin_top'] ) {
                if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
                    $styles[] = 'margin-top: ' . $atts['title_margin_top'];
                } else {
                    $styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
                }
            }

            return $styles;
        }

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['title_max_width'] ) ) {
				$styles[] = 'max-width: ' . $atts['title_max_width'];
			}

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

        private function get_text_holder_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['text_margin_top'] ) {
                if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
                    $styles[] = 'margin-top: ' . $atts['text_margin_top'];
                } else {
                    $styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
                }
            }

            return $styles;
        }

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_max_width'] ) ) {
				$styles[] = 'max-width: ' . $atts['text_max_width'];
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}

		private function generate_button_params( $atts ) {
			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'cyberdom_core_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);

			return $params;
		}

		private function generate_image_params( $atts ) {
			$image = array();

			if ( ! empty( $atts['image'] ) ) {
				$id = $atts['image'];

				$image['image_id'] = intval( $id );
				$image_original    = wp_get_attachment_image_src( $id, 'full' );
				$image['url']      = $image_original[0];
				$image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );

				$image_size = trim( $atts['image_size'] );
				preg_match_all( '/\d+/', $image_size, $matches ); /* check if numeral width and height are entered */
				if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ), true ) ) {
					$image['image_size'] = $image_size;
				} elseif ( ! empty( $matches[0] ) ) {
					$image['image_size'] = array(
						$matches[0][0],
						$matches[0][1]
					);
				} else {
					$image['image_size'] = 'full';
				}
			}

			return $image;
		}
	}
}
