<?php

if ( ! function_exists( 'cyberdom_core_add_icon_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function cyberdom_core_add_icon_widget( $widgets ) {
		$widgets[] = 'CyberdomCore_Icon_Widget';

		return $widgets;
	}

	add_filter( 'cyberdom_core_filter_register_widgets', 'cyberdom_core_add_icon_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class CyberdomCore_Icon_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'cyberdom_core_icon',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'cyberdom_core_icon' );
				$this->set_name( esc_html__( 'Cyberdom Icon', 'cyberdom-core' ) );
				$this->set_description( esc_html__( 'Add a icon element into widget areas', 'cyberdom-core' ) );
			}
		}

		public function render( $atts ) {
			echo CyberdomCore_Icon_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
