(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_divided_showcase_section = {};
	qodefCore.shortcodes.cyberdom_core_divided_showcase_section.qodefSwiper = qodef.qodefSwiper;

	$( document ).ready(
		function () {
			qodefDividedShowcaseSection.init();
		}
	);

	$( window ).on(
		'load',
		function () {
		}
	);

	var qodefDividedShowcaseSection = {
		init: function () {
			this.holder = $( '.qodef-divided-showcase-section' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $thisHolder = $( this );

						qodefDividedShowcaseSection.fullHeightSliderCalc( $thisHolder );

						$( window ).resize(
							function () {
								qodefDividedShowcaseSection.fullHeightSliderCalc( $thisHolder );
							}
						);

						if ( $thisHolder.hasClass('qodef-appear-animation--yes') ) {
							qodefDividedShowcaseSection.appearAnimation( $thisHolder );
						}
					}
				);
			}
		},
		fullHeightSliderCalc: function ( $holder ) {

			if ( $holder.hasClass( 'qodef-behavior--slider' ) ) {
				var windowHeight = (window.innerHeight || document.documentElement.clientHeight);
				var headerHeight = 0;

				if ( ! qodef.body.hasClass( 'qodef-header--transparent' ) ) {
					headerHeight = qodefGlobal.vars.headerHeight;
				}

				if ( qodefCore.windowWidth > 1024 ) {
					var sliderHeight = windowHeight - headerHeight - qodefGlobal.vars.topAreaHeight - qodefGlobal.vars.adminBarHeight;
				} else if ( qodefCore.windowWidth <= 1024 && qodefCore.windowWidth > 768 ) {
					sliderHeight = windowHeight - qodefGlobal.vars.mobileHeaderHeight - qodefGlobal.vars.adminBarHeight;
				} else if ( qodefCore.windowWidth <= 768 ) {
					sliderHeight = (windowHeight - qodefGlobal.vars.mobileHeaderHeight - qodefGlobal.vars.adminBarHeight) * 2; // height for flex direction column
				}

				if ( qodefCore.body.hasClass( 'qodef--passepartout' ) ) {
					var passepartoutSize = parseInt( qodefCore.body.css( 'padding-top' ) );
					sliderHeight -= passepartoutSize;
				}

				$holder.height( sliderHeight );
			}
		},
		appearAnimation ( $holder ) {
			if ( qodef.windowWidth > 768) {
				qodefCore.qodefIsInViewport.check(
					$holder,
					() => {
						$holder.addClass('qodef--appeared');
					}
				);
			} else {
				const $leftSide  = $holder.find('.qodef-left-info'),
					  $rightSide = $holder.find('.qodef-right-info');

				if ( $leftSide.length ) {
					qodefCore.qodefIsInViewport.check(
						$leftSide,
						() => {
							$leftSide.addClass('qodef--appeared');
						}
					);
				}

				if ( $rightSide.length ) {
					qodefCore.qodefIsInViewport.check(
						$rightSide,
						() => {
							$rightSide.addClass('qodef--appeared');
						}
					);
				}
			}
		}
	};

	qodefCore.shortcodes.cyberdom_core_divided_showcase_section.qodefDividedShowcaseSection = qodefDividedShowcaseSection;

})( jQuery );


