(function ($) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_circular_slider = {};

	$(document).ready(function () {
		qodefCircularSlider.init();
	});

	var qodefCircularSlider = {
		init: function () {
			this.holder = $('.qodef-circular-slider-holder');
			
			if (this.holder.length) {
				this.holder.each(function () {
					var $thisHolder = $(this);

					qodefCircularSlider.createSlider($thisHolder);
				});
			}
		},
		
		createSlider: function ($holder) {
			var $swiperHolder = $holder.find('.qodef-m-swiper'),
				$sliderHolder = $holder.find('.qodef-m-items'),
				$pagination = $holder.find('.swiper-pagination');
			
			var $thumbs = [];
			var $images = $sliderHolder.find('.qodef-m-slide-content img');
			$images.each(function() {
				$thumbs.push($(this).attr("src"));
			});
			
			var $swiper = new Swiper($swiperHolder, {
				slidesPerView: 'auto',
				centeredSlides: true,
				spaceBetween: 0,
				effect: 'fade',
				autoplay: {
					delay: 5000,
					disableOnInteraction: false
				},
				loop: true,
				speed: 300,
				pagination: {
					el: $pagination,
					type: 'bullets',
					clickable: true,
					renderBullet: function (index, className) {
						
						// autoplay delay & speed used for transition duration
						var transition = 5800;
						var gradientColorOne = getComputedStyle(document.documentElement).getPropertyValue('--qode-gradient-color-one');
						var gradientColorMiddle = getComputedStyle(document.documentElement).getPropertyValue('--qode-gradient-color-middle');
						var gradientColorTwo = getComputedStyle(document.documentElement).getPropertyValue('--qode-gradient-color-two');

						if ( $holder.hasClass('qodef-use-gradient-bg--yes') ) {
							return '<span class="' + className + '">' + '<svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102"><defs><linearGradient id="qodefGradientBackground" x1="0" x2="0" y1="0" y2="1"><stop offset="0%" stop-color="' + gradientColorOne + '"/><stop offset="40%" stop-color="' + gradientColorMiddle + '"/><stop offset="60%" stop-color="' + gradientColorMiddle + '"/><stop offset="100%" stop-color="' + gradientColorTwo + '"/></linearGradient></defs><path stroke="url(#qodefGradientBackground)" d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919; animation-duration: ' + transition + 'ms;"></path> </svg><img src=" ' + $thumbs[index] + ' ">' + '</span>';
						} else {
							return '<span class="' + className + '">' + '<svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102"><path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919; animation-duration: ' + transition + 'ms;"></path> </svg><img src=" ' + $thumbs[index] + ' ">' + '</span>';
						}
					}
				},
				on: {
					init: function () {
						setTimeout(function () {
							$sliderHolder.addClass('qodef-swiper--initialized');
							$pagination.find('.swiper-pagination-bullet').addClass('qodef--appear');
						}, 500);
					}
				}
			});
		}
	};

	qodefCore.shortcodes.cyberdom_core_circular_slider.qodefCircularSlider  = qodefCircularSlider;
	
})(jQuery);
