<?php

if ( ! function_exists( 'cyberdom_core_add_button_variation_circle' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function cyberdom_core_add_button_variation_circle( $variations ) {
		$variations['circle'] = esc_html__( 'Circle', 'cyberdom-core' );

		return $variations;
	}

	add_filter( 'cyberdom_core_filter_button_layouts', 'cyberdom_core_add_button_variation_circle' );
}

if ( ! function_exists( 'cyberdom_core_add_button_options_line_break_break' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function cyberdom_core_add_button_options_line_break_break( $options ) {
		$circle_button_options = array();

		$text_align_option = array(
			'field_type'  => 'select',
			'name'        => 'text_align',
			'title'       => esc_html__( 'Text Align', 'cyberdom-core' ),
			'options'    => array(
				''       => esc_html__( 'Default', 'cyberdom-core' ),
				'left'   => esc_html__( 'Left', 'cyberdom-core' ),
				'center' => esc_html__( 'Center', 'cyberdom-core' ),
				'right'  => esc_html__( 'Right', 'cyberdom-core' ),
			),
			'dependency' => array(
				'show' => array(
					'button_layout' => array(
						'values'        => 'circle',
						'default_value' => 'filled',
					),
				),
			),
		);

		$circle_button_options[] = $text_align_option;

		$line_break_option = array(
			'field_type'  => 'text',
			'name'        => 'line_break_positions',
			'title'       => esc_html__( 'Positions of Line Break', 'cyberdom-core' ),
			'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'cyberdom-core' ),
			'dependency' => array(
				'show' => array(
					'button_layout' => array(
						'values'        => 'circle',
						'default_value' => 'filled',
					),
				),
			),
		);

		$circle_button_options[] = $line_break_option;

		$line_break_disable_option = array(
			'field_type'    => 'select',
			'name'          => 'disable_text_break_words',
			'title'         => esc_html__( 'Disable Text Line Break', 'cyberdom-core' ),
			'description'   => esc_html__( 'Enabling this option will disable text line breaks for screen size 1024 and lower', 'cyberdom-core' ),
			'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
			'default_value' => 'no',
			'dependency' => array(
				'show' => array(
					'button_layout' => array(
						'values'        => 'circle',
						'default_value' => 'filled',
					),
				),
			),
		);

		$circle_button_options[] = $line_break_disable_option;

		return array_merge( $options, $circle_button_options );
	}

	add_filter( 'cyberdom_core_filter_button_extra_options', 'cyberdom_core_add_button_options_line_break_break', 10, 2 );
}
