(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_testimonials_list = {};

	$( window ).on(
		'load',
		() => {
			qodefTestimonialsList.init();
		}
	);

	const qodefTestimonialsList = {
		init () {
			this.testimonials = $('.qodef-testimonials-list');

			if ( this.testimonials.length ) {
				this.testimonials.each(
					( index, element ) => {
						const $thisTestimonials = $( element );

						if ( $thisTestimonials.hasClass('qodef-appear-animation--yes') ) {
							qodefTestimonialsList.appearAnimation( $thisTestimonials );
						}
					}
				);
			}
		},
		appearAnimation ( $holder ) {
			qodefCore.qodefIsInViewport.check(
				$holder,
				() => {
					$holder.addClass('qodef--appeared');
				}
			);
		}
	};

	qodefCore.shortcodes.cyberdom_core_testimonials_list.qodefTestimonialsList = qodefTestimonialsList;
	qodefCore.shortcodes.cyberdom_core_testimonials_list.qodefSwiper           = qodef.qodefSwiper;

})( jQuery );
