<?php
$title_tag = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h4';
$title = get_the_title();

if ( ! empty( $title ) && ! empty( $line_break_positions ) ) {
	$split_title          = explode( ' ', $title );
	$line_break_positions = explode( ',', str_replace( ' ', '', $line_break_positions ) );

	foreach ( $line_break_positions as $position ) {
		$position = intval( $position );
		if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
			$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
		}
	}

	$title = implode( ' ', $split_title );
}
?>
<<?php echo esc_attr( $title_tag ); ?> itemprop="name" class="qodef-woo-product-title entry-title" <?php qode_framework_inline_style( $this_shortcode->get_title_styles( $params ) ); ?>>
	<a itemprop="url" class="qodef-woo-product-title-link" href="<?php the_permalink(); ?>">
		<?php echo qode_framework_wp_kses_html( 'content', $title ); ?>
	</a>
</<?php echo esc_attr( $title_tag ); ?>>
