<?php

if ( ! function_exists( 'cyberdom_core_add_round_product_slider_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_round_product_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_RoundProductSlider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_round_product_slider_shortcode' );
}

if ( class_exists( 'CyberdomCore_List_Shortcode' ) ) {
	class CyberdomCore_RoundProductSlider_Shortcode extends CyberdomCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'product' );
			$this->set_post_type_taxonomy( 'product_cat' );
			$this->set_post_type_additional_taxonomies( array( 'product_tag', 'product_type' ) );
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_round_product_slider_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_round_product_slider_extra_options', array() ) );

			parent::__construct();
		}

		public $no_of_icons = 5;

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_PLUGINS_URL_PATH . '/woocommerce/shortcodes/round-product-slider' );
			$this->set_base( 'cyberdom_core_round_product_slider' );
			$this->set_name( esc_html__( 'Round Product Slider', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of products', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'use_gradient_background',
					'title'         => esc_html__( 'Use Gradient Color', 'cyberdom-core' ),
					'description'   => esc_html__( 'Use Gradient Color for product background (product image needs to be added with transparent background).', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'behavior',
					'title'         => esc_html__( 'List Appearance', 'cyberdom-core' ),
					'options'       => array(
						'slider' => esc_html__( 'Slider', 'cyberdom-core' ),
					),
					'default_value' => 'slider',
				)
			);
			$this->map_list_options(
				array(
					'exclude_option'   => array( 'behavior', 'images_proportion', 'columns', 'space', 'slider_slide_animation', 'slider_navigation' ),
				)
			);
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'filterby',
					'title'         => esc_html__( 'Filter By', 'cyberdom-core' ),
					'options'       => array(
						''             => esc_html__( 'Default', 'cyberdom-core' ),
						'on_sale'      => esc_html__( 'On Sale', 'cyberdom-core' ),
						'featured'     => esc_html__( 'Featured', 'cyberdom-core' ),
						'top_rated'    => esc_html__( 'Top Rated', 'cyberdom-core' ),
						'best_selling' => esc_html__( 'Best Selling', 'cyberdom-core' ),
					),
					'default_value' => '',
					'group'         => esc_html__( 'Query', 'cyberdom-core' ),
				)
			);
			$this->map_layout_options(
				array(
					'layouts' => $this->get_layouts(),
					'exclude_option'   => array( 'title_tag' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'line_break_positions',
					'title'       => esc_html__( 'Positions of Line Break', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'cyberdom-core' ),
					'group'       => esc_html__( 'Layout', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_title_break_words',
					'title'         => esc_html__( 'Disable Title Line Break', 'cyberdom-core' ),
					'description'   => esc_html__( 'Enabling this option will disable title line breaks for screen size 680 and lower', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Layout', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_text',
					'title'         => esc_html__( 'Button Text', 'cyberdom-core' ),
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_link',
					'title'         => esc_html__( 'Button Link', 'cyberdom-core' ),
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'button_target',
					'title'         => esc_html__( 'Button Target', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'icon_layout',
					'title'         => esc_html__( 'Icons Layout', 'cyberdom-core' ),
					'options'       => array(
						'normal'  => esc_html__( 'Normal', 'cyberdom-core' ),
						'circle'  => esc_html__( 'Circle', 'cyberdom-core' ),
						'square'  => esc_html__( 'Square', 'cyberdom-core' ),
						'textual' => esc_html__( 'Textual', 'cyberdom-core' ),
					),
					'default_value' => 'normal',
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			for ( $i = 1; $i <= $this->no_of_icons; $i ++ ) {
				$this->set_option(
					array(
						'field_type' => 'iconpack',
						'name'       => 'main_icon_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'text_icon_' . $i,
						'title'      => sprintf( esc_html__( 'Text Icon %s', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'show' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'link_' . $i,
						'title'      => sprintf( esc_html__( 'Link %s', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type'    => 'select',
						'name'          => 'target_' . $i,
						'title'         => sprintf( esc_html__( 'Link %s Target', 'cyberdom-core' ), $i ),
						'options'       => cyberdom_core_get_select_type_options_pool( 'link_target', false ),
						'default_value' => '_blank',
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'custom_size_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Size', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'margin_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Margin', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Color', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_background_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Background Color', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_hover_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Hover Color', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_hover_background_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Hover Background Color', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
			}
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'cyberdom_core_round_product_slider', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			// Fixed atts
			$atts['images_proportion'] = 'full';
			$atts['slider_slide_animation'] = '';
			$atts['slider_navigation'] = 'no';
			$atts['slider_direction'] = 'vertical';
			$atts['centered_slides'] = true;
			$atts['slider_scroll'] = true;
			$atts['columns'] = 1.37;
			$atts['space'] = 'no';
			$atts['columns_responsive'] = 'custom';
			$atts['columns_1440'] = 1.37;
			$atts['columns_1366'] = 1.37;
			$atts['columns_1280'] = 1.4;
			$atts['columns_1024'] = 1;
			$atts['columns_768'] = 1;
			$atts['columns_680'] = 1;
			$atts['columns_480'] = 1;
			$atts['title_tag'] = 'h1';

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['query_result']   = new \WP_Query( cyberdom_core_get_query_params( $atts ) );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
			$atts['data_attr']      = cyberdom_core_get_pagination_data( CYBERDOM_CORE_REL_PATH, 'plugins/woocommerce/shortcodes', 'round-product-slider', 'product', $atts );

			$atts['this_shortcode'] = $this;

			return cyberdom_core_get_template_part( 'plugins/woocommerce/shortcodes/round-product-slider', 'templates/content', $atts['behavior'], $atts );
		}

		public function get_additional_query_args( $atts ) {
			$args = parent::get_additional_query_args( $atts );

			if ( ! empty( $atts['filterby'] ) ) {
				switch ( $atts['filterby'] ) {
					case 'on_sale':
						$sale_products         = wc_get_product_ids_on_sale();
						$args['no_found_rows'] = 1;
						$args['post__in']      = array_merge( array( 0 ), $sale_products );

						if ( ! empty( $atts['additional_params'] ) && 'id' === $atts['additional_params'] && ! empty( $atts['post_ids'] ) ) {
							$post_ids          = array_map( 'intval', explode( ',', $atts['post_ids'] ) );
							$new_sale_products = array();

							foreach ( $post_ids as $post_id ) {
								if ( in_array( $post_id, $sale_products, true ) ) {
									$new_sale_products[] = $post_id;
								}
							}

							if ( ! empty( $new_sale_products ) ) {
								$args['post__in'] = $new_sale_products;
							}
						}

						break;
					case 'featured':
						$featured_tax_query   = WC()->query->get_tax_query();
						$featured_tax_query[] = array(
							'taxonomy'         => 'product_visibility',
							'terms'            => 'featured',
							'field'            => 'name',
							'operator'         => 'IN',
							'include_children' => false,
						);

						if ( isset( $args['tax_query'] ) && ! empty( $args['tax_query'] ) ) {
							$args['tax_query'] = array_merge( $args['tax_query'], $featured_tax_query );
						} else {
							$args['tax_query'] = $featured_tax_query;
						}

						break;
					case 'top_rated':
						$args['meta_key'] = '_wc_average_rating';
						$args['order']    = 'DESC';
						$args['orderby']  = 'meta_value_num';
						break;
					case 'best_selling':
						$args['meta_key'] = 'total_sales';
						$args['order']    = 'DESC';
						$args['orderby']  = 'meta_value_num';
						break;
				}
			}

			return $args;
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-woo-shortcode';
			$holder_classes[] = 'qodef-woo-product-list';
			$holder_classes[] = 'qodef-woo-round-product-slider';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';
			$holder_classes[] = 'yes' === $atts['use_gradient_background'] ? 'qodef-use-gradient-bg--yes' : '';
			$holder_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes      = $this->init_item_classes();
			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}
	}
}
