<?php

if ( ! function_exists( 'cyberdom_core_cf7_add_submit_form_tag' ) ) {
	/**
	 * Function that override default submit buttom html tag
	 */
	function cyberdom_core_cf7_add_submit_form_tag() {
		wpcf7_add_form_tag( 'submit', 'cyberdom_core_cf7_submit_form_tag_handler' );
	}
}

if ( ! function_exists( 'cyberdom_core_cf7_submit_form_tag_handler' ) ) {
	/**
	 * Function that override default submit buttom html tag
	 *
	 * @param array $tag
	 *
	 * @return string
	 */
	function cyberdom_core_cf7_submit_form_tag_handler( $tag ) {
		$tag   = new WPCF7_FormTag( $tag );
		$class = wpcf7_form_controls_class( $tag->type );

		$atts             = array();
		$atts['class']    = $tag->get_class_option( $class );
		$atts['class']   .= ' qodef-button qodef-size--normal qodef-layout--filled qodef-m';
		$atts['id']       = $tag->get_id_option();
		$atts['tabindex'] = $tag->get_option( 'tabindex', 'int', true );

		$value = isset( $tag->values[0] ) ? $tag->values[0] : '';
		if ( empty( $value ) ) {
			$value = esc_html__( 'Send', 'cyberdom-core' );
		}

		$atts['type'] = 'submit';
		$atts         = wpcf7_format_atts( $atts );

		$html = sprintf( '<button %1$s><span class="qodef-m-text">%2$s</span><span class="qodef-m-arrow"><svg xmlns="http://www.w3.org/2000/svg" width="12.244" height="12.23" viewBox="0 0 12.244 12.23"><g transform="translate(-1106.786 -10182.84)"><path d="M-12242.786,3311.378h11.463v11.457" transform="translate(13349.702 6872.112)" fill="none" stroke="currentColor" stroke-width="1.3"></path><line y1="11.108" x2="11.258" transform="translate(1107.242 10183.5)" fill="none" stroke="currentColor" stroke-width="1.3"></line></g></svg><svg xmlns="http://www.w3.org/2000/svg" width="12.244" height="12.23" viewBox="0 0 12.244 12.23"><g transform="translate(-1106.786 -10182.84)"><path d="M-12242.786,3311.378h11.463v11.457" transform="translate(13349.702 6872.112)" fill="none" stroke="currentColor" stroke-width="1.3"></path><line y1="11.108" x2="11.258" transform="translate(1107.242 10183.5)" fill="none" stroke="currentColor" stroke-width="1.3"></line></g></svg></span></button>', $atts, $value );

		return $html;
	}
}
