<?php

if ( ! function_exists( 'cyberdom_core_add_general_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function cyberdom_core_add_general_options( $page ) {

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_main_color',
					'title'       => esc_html__( 'Main Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose the most dominant theme color', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_additional_color',
					'title'       => esc_html__( 'Additional Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose the additional theme color', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_gradient_color_one',
					'title'       => esc_html__( 'Gradient Color One', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose first color for gradient', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_gradient_color_middle',
					'title'       => esc_html__( 'Gradient Color Middle', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose middle color for gradient', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_gradient_color_two',
					'title'       => esc_html__( 'Gradient Color Two', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose second color for gradient', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_background_color',
					'title'       => esc_html__( 'Page Background Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Set background color', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_page_background_image',
					'title'       => esc_html__( 'Page Background Image', 'cyberdom-core' ),
					'description' => esc_html__( 'Set background image', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_repeat',
					'title'       => esc_html__( 'Page Background Image Repeat', 'cyberdom-core' ),
					'description' => esc_html__( 'Set background image repeat', 'cyberdom-core' ),
					'options'     => array(
						''          => esc_html__( 'Default', 'cyberdom-core' ),
						'no-repeat' => esc_html__( 'No Repeat', 'cyberdom-core' ),
						'repeat'    => esc_html__( 'Repeat', 'cyberdom-core' ),
						'repeat-x'  => esc_html__( 'Repeat-x', 'cyberdom-core' ),
						'repeat-y'  => esc_html__( 'Repeat-y', 'cyberdom-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_size',
					'title'       => esc_html__( 'Page Background Image Size', 'cyberdom-core' ),
					'description' => esc_html__( 'Set background image size', 'cyberdom-core' ),
					'options'     => array(
						''        => esc_html__( 'Default', 'cyberdom-core' ),
						'contain' => esc_html__( 'Contain', 'cyberdom-core' ),
						'cover'   => esc_html__( 'Cover', 'cyberdom-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_attachment',
					'title'       => esc_html__( 'Page Background Image Attachment', 'cyberdom-core' ),
					'description' => esc_html__( 'Set background image attachment', 'cyberdom-core' ),
					'options'     => array(
						''       => esc_html__( 'Default', 'cyberdom-core' ),
						'fixed'  => esc_html__( 'Fixed', 'cyberdom-core' ),
						'scroll' => esc_html__( 'Scroll', 'cyberdom-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding',
					'title'       => esc_html__( 'Page Content Padding', 'cyberdom-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding_mobile',
					'title'       => esc_html__( 'Page Content Padding Mobile', 'cyberdom-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed',
					'title'         => esc_html__( 'Boxed Layout', 'cyberdom-core' ),
					'description'   => esc_html__( 'Set boxed layout', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section = $page->add_section_element(
				array(
					'name'       => 'qodef_boxed_section',
					'title'      => esc_html__( 'Boxed Layout Section', 'cyberdom-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_boxed' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed_disabled_680',
					'title'         => esc_html__( 'Disable Boxed Layout On Mobile', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed_header_and_title_outside',
					'title'         => esc_html__( 'Force Fixed Header and Title Area outside the Boxed Layout', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed_footer_outside',
					'title'         => esc_html__( 'Force Footer outside the Boxed Layout', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_boxed_background_color',
					'title'       => esc_html__( 'Boxed Background Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Set boxed background color', 'cyberdom-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_boxed_background_pattern',
					'title'       => esc_html__( 'Boxed Background Pattern', 'cyberdom-core' ),
					'description' => esc_html__( 'Set boxed background pattern', 'cyberdom-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_boxed_background_pattern_behavior',
					'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'cyberdom-core' ),
					'description' => esc_html__( 'Set boxed background pattern behavior', 'cyberdom-core' ),
					'options'     => array(
						'fixed'   => esc_html__( 'Fixed', 'cyberdom-core' ),
						'scroll'  => esc_html__( 'Scroll', 'cyberdom-core' ),
						'unset'   => esc_html__( 'Unset', 'cyberdom-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_passepartout',
					'title'         => esc_html__( 'Passepartout', 'cyberdom-core' ),
					'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$passepartout_section = $page->add_section_element(
				array(
					'name'       => 'qodef_passepartout_section',
					'title'      => esc_html__( 'Passepartout Section', 'cyberdom-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_passepartout' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_passepartout_color',
					'title'       => esc_html__( 'Passepartout Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose background color for passepartout', 'cyberdom-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_passepartout_image',
					'title'       => esc_html__( 'Passepartout Background Image', 'cyberdom-core' ),
					'description' => esc_html__( 'Set background image for passepartout', 'cyberdom-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size',
					'title'       => esc_html__( 'Passepartout Size', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout', 'cyberdom-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'cyberdom-core' ),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size_responsive',
					'title'       => esc_html__( 'Passepartout Responsive Size', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'cyberdom-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'cyberdom-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_content_width',
					'title'         => esc_html__( 'Initial Width of Content', 'cyberdom-core' ),
					'description'   => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'content_width', false ),
					'default_value' => '1100',
				)
			);

            $page->add_field_element(
                array(
                    'field_type'    => 'yesno',
                    'name'          => 'qodef_disable_images_lazy_loading',
                    'title'         => esc_html__( 'Disable Images Lazy Loading', 'cyberdom-core' ),
                    'description'   => esc_html__( 'Note that some images that have hover animation will not load if this option is turned off', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes'
                )
            );

			// Hook to include additional options after module options
			do_action( 'cyberdom_core_action_after_general_options_map', $page );

			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_custom_js',
					'title'       => esc_html__( 'Custom JS', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter your custom JavaScript here', 'cyberdom-core' ),
				)
			);
		}
	}

	add_action( 'cyberdom_core_action_default_options_init', 'cyberdom_core_add_general_options', cyberdom_core_get_admin_options_map_position( 'general' ) );
}
