<?php

if ( ! function_exists( 'cyberdom_core_add_fonts_options' ) ) {
	/**
	 * Function that add options for this module
	 */
	function cyberdom_core_add_fonts_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => CYBERDOM_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'fonts',
				'title'       => esc_html__( 'Fonts', 'cyberdom-core' ),
				'description' => esc_html__( 'Global Fonts Options', 'cyberdom-core' ),
				'icon'        => 'fa fa-cog',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_google_fonts',
					'title'         => esc_html__( 'Enable Google Fonts', 'cyberdom-core' ),
					'default_value' => 'yes',
					'args'          => array(
						'custom_class' => 'qodef-enable-google-fonts',
					),
				)
			);

			$google_fonts_section = $page->add_section_element(
				array(
					'name'       => 'qodef_google_fonts_section',
					'title'      => esc_html__( 'Google Fonts Options', 'cyberdom-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_enable_google_fonts' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$page_repeater = $google_fonts_section->add_repeater_element(
				array(
					'name'        => 'qodef_choose_google_fonts',
					'title'       => esc_html__( 'Google Fonts to Include', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose Google Fonts which you want to use on your website', 'cyberdom-core' ),
					'button_text' => esc_html__( 'Add New Google Font', 'cyberdom-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type'  => 'googlefont',
					'name'        => 'qodef_choose_google_font',
					'title'       => esc_html__( 'Google Font', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose Google Font', 'cyberdom-core' ),
					'args'        => array(
						'include' => 'google-fonts',
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_weight',
					'title'       => esc_html__( 'Google Fonts Weight', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts weights for your website. Impact on page load time', 'cyberdom-core' ),
					'options'     => array(
						'100'  => esc_html__( '100 Thin', 'cyberdom-core' ),
						'100i' => esc_html__( '100 Thin Italic', 'cyberdom-core' ),
						'200'  => esc_html__( '200 Extra-Light', 'cyberdom-core' ),
						'200i' => esc_html__( '200 Extra-Light Italic', 'cyberdom-core' ),
						'300'  => esc_html__( '300 Light', 'cyberdom-core' ),
						'300i' => esc_html__( '300 Light Italic', 'cyberdom-core' ),
						'400'  => esc_html__( '400 Regular', 'cyberdom-core' ),
						'400i' => esc_html__( '400 Regular Italic', 'cyberdom-core' ),
						'500'  => esc_html__( '500 Medium', 'cyberdom-core' ),
						'500i' => esc_html__( '500 Medium Italic', 'cyberdom-core' ),
						'600'  => esc_html__( '600 Semi-Bold', 'cyberdom-core' ),
						'600i' => esc_html__( '600 Semi-Bold Italic', 'cyberdom-core' ),
						'700'  => esc_html__( '700 Bold', 'cyberdom-core' ),
						'700i' => esc_html__( '700 Bold Italic', 'cyberdom-core' ),
						'800'  => esc_html__( '800 Extra-Bold', 'cyberdom-core' ),
						'800i' => esc_html__( '800 Extra-Bold Italic', 'cyberdom-core' ),
						'900'  => esc_html__( '900 Ultra-Bold', 'cyberdom-core' ),
						'900i' => esc_html__( '900 Ultra-Bold Italic', 'cyberdom-core' ),
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_subset',
					'title'       => esc_html__( 'Google Fonts Style', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts style for your website. Impact on page load time', 'cyberdom-core' ),
					'options'     => array(
						'latin'        => esc_html__( 'Latin', 'cyberdom-core' ),
						'latin-ext'    => esc_html__( 'Latin Extended', 'cyberdom-core' ),
						'cyrillic'     => esc_html__( 'Cyrillic', 'cyberdom-core' ),
						'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'cyberdom-core' ),
						'greek'        => esc_html__( 'Greek', 'cyberdom-core' ),
						'greek-ext'    => esc_html__( 'Greek Extended', 'cyberdom-core' ),
						'vietnamese'   => esc_html__( 'Vietnamese', 'cyberdom-core' ),
					),
				)
			);

			$page_repeater = $page->add_repeater_element(
				array(
					'name'        => 'qodef_custom_fonts',
					'title'       => esc_html__( 'Custom Fonts', 'cyberdom-core' ),
					'description' => esc_html__( 'Add custom fonts', 'cyberdom-core' ),
					'button_text' => esc_html__( 'Add New Custom Font', 'cyberdom-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_ttf',
					'title'      => esc_html__( 'Custom Font TTF', 'cyberdom-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_otf',
					'title'      => esc_html__( 'Custom Font OTF', 'cyberdom-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff',
					'title'      => esc_html__( 'Custom Font WOFF', 'cyberdom-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff2',
					'title'      => esc_html__( 'Custom Font WOFF2', 'cyberdom-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_custom_font_name',
					'title'      => esc_html__( 'Custom Font Name', 'cyberdom-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'cyberdom_core_action_after_page_fonts_options_map', $page );
		}
	}

	add_action( 'cyberdom_core_action_default_options_init', 'cyberdom_core_add_fonts_options', cyberdom_core_get_admin_options_map_position( 'fonts' ) );
}
