(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_blog_list = {};

	$( window ).on(
		'load',
		() => {
			qodefBlogList.init();
		}
	);

	const qodefBlogList = {
		init () {
			this.blog = $('.qodef-blog');

			if ( this.blog.length ) {
				this.blog.each(
					( index, element ) => {
						const $thisBlogList = $( element );

						if ( $thisBlogList.hasClass('qodef-hover-animation--yes') ) {
							qodefBlogList.linkHover( $thisBlogList );
						}
					}
				);
			}
		},
		linkHover ( $holder ) {
			const $items = $holder.find('.qodef-blog-item');

			$items.each(
				( index, element ) => {
					const $thisItem = $( element ),
						$itemMedia = $thisItem.find('.qodef-e-media-image > a'),
						$titleLink = $thisItem.find('.qodef-e-title-link');

					if ( $itemMedia.length ) {
						$itemMedia.on(
							'mouseenter',
							() => {
								$thisItem.addClass('qodef--active');
							}
						);

						$itemMedia.on(
							'mouseleave',
							() => {
								$thisItem.removeClass('qodef--active');
							}
						);
					}

					if ( $titleLink.length ) {
						$titleLink.on(
							'mouseenter',
							() => {
								$thisItem.addClass('qodef--active');
							}
						);

						$titleLink.on(
							'mouseleave',
							() => {
								$thisItem.removeClass('qodef--active');
							}
						);
					}
				}
			);
		}
	};

	qodefCore.shortcodes.cyberdom_core_blog_list.qodefBlogList      = qodefBlogList;
	qodefCore.shortcodes.cyberdom_core_blog_list.qodefResizeIframes = qodef.qodefResizeIframes;

})( jQuery );
