<?php

if ( ! function_exists( 'cyberdom_core_add_blog_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function cyberdom_core_add_blog_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'post' ),
				'type'  => 'meta',
				'slug'  => 'blog-single',
				'title' => esc_html__( 'Blog Single', 'cyberdom-core' ),
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_blog_list_image',
					'title'       => esc_html__( 'Blog List Image', 'cyberdom-core' ),
					'description' => esc_html__( 'Upload image to be displayed on blog list instead of featured image', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_masonry_image_dimension_post',
					'title'       => esc_html__( 'Image Dimension', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose an image layout for blog list. If you are using fixed image proportions on the list, choose an option other than default', 'cyberdom-core' ),
					'options'     => cyberdom_core_get_select_type_options_pool( 'masonry_image_dimension' ),
				)
			);
			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_masonry_background_color_post',
					'title'       => esc_html__( 'Background Color', 'cyberdom-core' ),
					'description' => esc_html__( 'If you are using fixed image proportions on the list, choose a background color to be displayed instead of the image', 'cyberdom-core' ),
					'options'     => cyberdom_core_get_select_type_options_pool( 'masonry_image_dimension' ),
				)
			);
			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'use_gradient_background_post',
					'title'         => esc_html__( 'Use Gradient Color', 'cyberdom-core' ),
					'description'   => esc_html__( 'Use Gradient Color for the background', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);
            $page->add_field_element(
                array(
                    'field_type'    => 'select',
                    'name'          => 'gradient_background_alternative_animation',
                    'title'         => esc_html__( 'Gradient Color Alternative Animation', 'cyberdom-core' ),
                    'description'   => esc_html__( 'Alternative animation of Gradient Color for the background', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                    'dependency'    => array(
                        'show' => array(
                            'use_gradient_background_post' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );

			// Hook to include additional options after module options
			do_action( 'cyberdom_core_action_after_blog_single_meta_box_map', $page );
		}
	}

	add_action( 'cyberdom_core_action_default_meta_boxes_init', 'cyberdom_core_add_blog_single_meta_box', 1 ); // Permission 1 is set in order to this module be at the first place
}
